from mail.ipa.ipa.core.crypto.versioned import (
    VersionedKeyStorage, VersionedManagedBlockDecryptor, VersionedManagedBlockEncryptor
)


class Fernet:
    """
    Названо в честь Fernet из пакета cryptography
    Это такой класс, которому даёшь версионированное хранилище ключей,
    а потом можешь дёргать encrypt и получать готовый шифротекст с
    шифрованием AES-CBC-PKCS7.
    Идеально для шифрования текста небольшой длины.

    WARN: в отличие от Fernet из cryptography, тут нету AEAD (aka аутентификация шифротекста)
    Ты, вероятно, хочешь AEAD, если ты отдаёшь шифротексты наружу и/или принимаешь их извне.
    WARN: не вздумай использовать это в "блочном режиме". Шифруешь данные - передавай их
    в encrypt полностью. Не бей на блоки.
    """
    def __init__(self, key_storage: VersionedKeyStorage) -> None:
        self._storage: VersionedKeyStorage = key_storage

    def encrypt(self, data: bytes) -> bytes:
        encryptor = VersionedManagedBlockEncryptor(self._storage)
        return encryptor.update(data) + encryptor.finalize()

    def decrypt(self, data: bytes) -> bytes:
        decryptor = VersionedManagedBlockDecryptor(self._storage)
        return decryptor.update(data) + decryptor.finalize()
