from dataclasses import dataclass, field
from datetime import datetime
from typing import Any, ClassVar, Dict, Optional, Type

from sendr_aiopg.storage.entity import Entity
from sendr_utils import utcnow

from mail.ipa.ipa.core.entities.enums import EventType
from mail.ipa.ipa.storage.exceptions import EventNotFound


@dataclass
class Event(Entity):
    org_id: int
    event_type: EventType
    revision: int
    data: Dict[str, Any] = field(default_factory=dict)
    event_id: Optional[int] = None
    created_at: datetime = field(default_factory=utcnow)

    DoesNotExist: ClassVar[Type[Exception]] = EventNotFound
