from dataclasses import asdict, dataclass
from typing import Any, Dict


@dataclass
class GeneralImportParams:
    """
    Для любой массовой операции импорта эти параметры являются общими.
    То есть, если мы хотим залить CSV из 100 пользователей, каждый создаваемый
    нами сборщик будет нацелен на разные ящики. Но эти параметры у всех сборщиков
    будут одинаковыми.
    """
    server: str
    port: int
    ssl: bool
    imap: bool
    mark_archive_read: bool
    delete_msgs: bool

    def as_dict(self) -> Dict[str, Any]:
        return asdict(self)


@dataclass
class GeneralInitImportParams(GeneralImportParams):
    """
    Application-level entity
    Любой операции массового создания сборщиков требуются эти параметры для того, чтобы понимать,
    в какой организации мы будем создавать пользователей для импорта.
    При этом, admin_uid и user_ip нужны для авторизации запросов к директории.
    """
    org_id: int
    admin_uid: int
    user_ip: str


@dataclass
class ImportParams(GeneralImportParams):
    """
    Database-level entity
    В базе данных мы храним эту информацию в таблице со сборщиками.
    Технической необходимости в этом нет, чисто для справки/аналитики/отладки.
    """
    src_login: str
