import crypt
from base64 import b64decode, b64encode
from dataclasses import dataclass
from typing import Any, ClassVar

from mail.ipa.ipa.core.crypto import Fernet


@dataclass
class Password:
    _fernet: ClassVar[Fernet] = Fernet()
    # зашифрованный пароль. TODO: переименовать в encrypted_password?
    password: str  # TODO: затестить флоу по созданию таски и её взятию

    @classmethod
    def from_plain(cls, plain: str) -> 'Password':
        password = b64encode(cls._fernet.encrypt(plain.encode('utf8'))).decode('ascii')
        return cls(password)

    def value(self) -> str:
        return self._fernet.decrypt(b64decode(self.password)).decode('utf8')

    def md5crypt(self) -> str:
        salt = crypt.mksalt(method=crypt.METHOD_MD5)
        return crypt.crypt(self.value(), salt=salt)

    def encrypted(self) -> str:
        return self.password

    def __eq__(self, other: Any) -> bool:
        if isinstance(other, type(self)):
            return self.value() == other.value()
        return False

    def __str__(self) -> str:
        return 'Password'
