from dataclasses import dataclass
from typing import List, Optional, Union

from sendr_taskqueue.worker.storage.db.entities import Task as BaseTask

from mail.ipa.ipa.core.entities.enums import TaskState
from mail.ipa.ipa.core.entities.not_fetched import NOT_FETCHED, NotFetchedType


@dataclass
class Task(BaseTask):
    entity_id: Optional[int] = None
    meta_task_id: Optional[int] = None
    meta_info: Optional[dict] = None
    nonterminal_children: Union[NotFetchedType, int] = NOT_FETCHED
    failed_children: Union[NotFetchedType, int] = NOT_FETCHED

    NONTERMINAL_TASK_STATES = (TaskState.PENDING, TaskState.PROCESSING)

    @property
    def root_task_id(self) -> int:
        return self.meta_task_id or self.task_id

    @property
    def finished(self) -> bool:
        assert self.nonterminal_children is not NOT_FETCHED

        return self.state not in self.NONTERMINAL_TASK_STATES and self.nonterminal_children == 0

    @property
    def has_errors(self) -> bool:
        assert self.failed_children is not NOT_FETCHED

        return self.failed_children > 0


@dataclass
class TasksPage:
    tasks: List[Task]
    total: int
    limit: int
    offset: int
