from dataclasses import dataclass, field
from datetime import datetime
from typing import TYPE_CHECKING, ClassVar, Optional, Union

from sendr_utils import utcnow

from mail.ipa.ipa.core.entities.not_fetched import NOT_FETCHED, NotFetchedType

if TYPE_CHECKING:
    from mail.ipa.ipa.core.entities.collector import Collector  # noqa


@dataclass
class User:

    UNKNOWN_ERROR: ClassVar[str] = 'unknown_error'

    org_id: int
    login: str
    user_id: Optional[int] = None
    uid: Optional[int] = None

    # Мы сохраняем suid в базу при создании пользователя. Технически, suid может меняться.
    # Но только в экзотических случаях. Например:
    # Берём портальный аккаунт, удаляем ему почту и создаём заново.
    suid: Optional[int] = None

    created_at: Optional[datetime] = field(default_factory=utcnow)
    modified_at: Optional[datetime] = field(default_factory=utcnow)
    error: Optional[str] = None

    # joined
    collector: Union[None, NotFetchedType, 'Collector'] = NOT_FETCHED
