from dataclasses import dataclass
from typing import Optional

from mail.ipa.ipa.core.entities.password import Password


@dataclass
class UserInfo:
    login: str
    password: Password
    src_login: str
    new_password: Optional[Password] = None
    first_name: Optional[str] = None
    last_name: Optional[str] = None
    middle_name: Optional[str] = None
    gender: Optional[str] = None
    birthday: Optional[str] = None
    language: Optional[str] = None

    @staticmethod
    def _normalize_login(login: str) -> str:
        return login.strip().lower()

    @staticmethod
    def _normalize_value(value: Optional[str]) -> Optional[str]:
        if value is None:
            return None
        value = value.strip()
        if not value:
            return None

        return value

    def __post_init__(self):
        self.login = self._normalize_login(self.login)
        self.birthday = self._normalize_value(self.birthday)
        self.gender = self._normalize_value(self.gender)
        self.language = self._normalize_value(self.language)
        self.first_name = self._normalize_value(self.first_name)
        self.last_name = self._normalize_value(self.last_name)
        self.middle_name = self._normalize_value(self.middle_name)
