from typing import ClassVar, Dict, Type

from mail.ipa.ipa.interactions.exceptions import InteractionResponseError


class BlackboxBaseError(InteractionResponseError[str]):
    """
    https://docs.yandex-team.ru/blackbox/concepts/blackboxErrors
    """

    _exceptions_by_code: ClassVar[Dict[str, Type[InteractionResponseError]]] = {}


class BlackboxUserNotFoundError(BlackboxBaseError):
    """
    Пользователя не существует.

    blackbox/userinfo не вернёт ошибку, если пользователя не существует. Просто поля будут пустыми.
    Пример:
    curl 'http://pass-test.yandex.ru/blackbox' --data 'method=userinfo&userip=127.0.0.1' \
            --data 'uid=123123123123&dbfields=subscription.suid.2&format=json'
    > {"users":[{"id":"123123123123","uid":{},"karma":{"value":0},"karma_status":{"value":0}}]}
    Ещё пример:
    curl 'http://blackbox.yandex.net/blackbox/' --data 'method=userinfo&userip=127.0.0.1' \
            --data 'uid=999123897&dbfields=subscription.suid.2&format=json'
    {"users":[{"id":"999123897","uid":{"value":"999123897","lite":false,"hosted":false},"login":"nomail20191217-1","have_password":true,"have_hint":true,"karma":{"value":0},"karma_status":{"value":0}}]}
    Пользователь существует, но почтовый ящик был удалён, поэтому suid нету.
    Ещё пример ответа (ящик тоже удалён):
    {"users":[{"id":"999123897","uid":{"value":"999123897","lite":false,"hosted":false},"login":"nomail20191217-1","have_password":true,"have_hint":true,"karma":{"value":0},"karma_status":{"value":0},"dbfields":{"subscription.suid.2":""}}]}
    """
    CODE = 'user_not_found'
