from dataclasses import dataclass
from enum import Enum, unique
from typing import Any, Dict, List


@dataclass
class DirectoryUser:
    uid: int
    email: str

    @classmethod
    def from_directory_response(cls, response: Dict[str, Any]) -> 'DirectoryUser':
        return cls(
            uid=response['id'],
            email=response['email'],
        )


@unique
class PasswordMode(Enum):
    HASH = 'hash'
    PLAIN = 'plain'


@dataclass
class DirectoryDomains:
    all: List[str]
    owned: List[str]
    master: str
    display: str


@dataclass
class DirectoryOrg:
    id: int
    domains: DirectoryDomains

    @classmethod
    def from_directory_response(cls, response: Dict[str, Any]) -> 'DirectoryOrg':
        return cls(
            id=response['id'],
            domains=DirectoryDomains(**response['domains']),
        )
