from typing import ClassVar, Dict, Type

from mail.ipa.ipa.interactions.exceptions import InteractionResponseError


class DirectoryBaseError(InteractionResponseError[str]):
    """
    https://api-internal.directory.ws.yandex.net/docs/playground.html
    https://github.yandex-team.ru/yandex-directory/yandex-directory
    """

    _exceptions_by_code: ClassVar[Dict[str, Type[InteractionResponseError]]] = {}


class DirectoryForbiddenError(DirectoryBaseError):
    """
    Пользователь не имеет право на операцию в организации.
    """
    CODE = 'forbidden'


class DirectoryNotFoundError(DirectoryBaseError):
    CODE = 'not_found'


class DirectoryOrganizationNotFoundError(DirectoryBaseError):
    pass


class DirectoryOrganizationDeletedError(DirectoryOrganizationNotFoundError):
    CODE = 'organization_deleted'


class DirectoryUnknownOrganizationError(DirectoryOrganizationNotFoundError):
    CODE = 'unknown_organization'


class DirectoryUserExistsError(DirectoryBaseError):
    CODE = 'some_user_has_this_login'


class DirectoryLoginProhibitedError(DirectoryBaseError):
    CODE = 'login.prohibitedsymbols'


class DirectoryLoginLongError(DirectoryBaseError):
    CODE = 'login.long'


class DirectoryPasswordWeakError(DirectoryBaseError):
    CODE = 'password.weak'


class DirectoryPasswordShortError(DirectoryBaseError):
    CODE = 'password.short'


class DirectoryBirthdayInvalidError(DirectoryBaseError):
    CODE = 'invalid_birthday'


class DirectoryDepartmentExistsError(DirectoryBaseError):
    CODE = 'some_department_has_this_label'
