from typing import ClassVar, Dict, Type

from mail.ipa.ipa.interactions.exceptions import InteractionResponseError


class MDSBaseError(InteractionResponseError[int]):
    """
    https://wiki.yandex-team.ru/mds/dev/protocol/#oshibki
    """

    _exceptions_by_code: ClassVar[Dict[int, Type[InteractionResponseError]]] = {}


class MDSForbiddenError(MDSBaseError):
    """
    Запрос был сформирован к уже существующему объекту, и перезапись объектов запрещена для неймспейса (по умолчанию).
    В теле 403 возвращается существующий ключ.
    В запросе был указан TTL, и TTL запрещен для неймспейса, или указанное значение TTL
    находится вне допустимых неймспейсу пределов.
    """
    CODE = 403


class MDSInsufficientStorageError(MDSBaseError):
    """
    В неймспейсе недостаточно свободного места для записи данного объекта.
    """
    CODE = 507


class MDSNotFoundError(MDSBaseError):
    """
    Файл был удалён.
    Мы используем MDS с TTL. Сами файл не удаляем.
    Поэтому такого быть не должно.
    """
    CODE = 404
