from sendr_aiopg import StorageAnnotatedMeta, StorageBase, StorageContextBase

from mail.ipa.ipa.storage.gateways.stat import StatGateway
from mail.ipa.ipa.storage.mappers.collector.mapper import CollectorMapper
from mail.ipa.ipa.storage.mappers.event import EventMapper
from mail.ipa.ipa.storage.mappers.organization import OrganizationMapper
from mail.ipa.ipa.storage.mappers.task import TaskMapper
from mail.ipa.ipa.storage.mappers.user.mapper import UserMapper
from mail.ipa.ipa.storage.mappers.worker import WorkerMapper


class Storage(StorageBase, metaclass=StorageAnnotatedMeta):
    collector: CollectorMapper
    event: EventMapper
    organization: OrganizationMapper
    stat: StatGateway
    task: TaskMapper
    user: UserMapper
    worker: WorkerMapper


class StorageContext(StorageContextBase):
    STORAGE_CLS = Storage
