import sqlalchemy as sa
from sqlalchemy.dialects.postgresql import JSONB

from sendr_taskqueue.worker.storage.db.tables import get_task_state, get_task_type
from sendr_utils import enum_values

from mail.ipa.ipa.core.entities.enums import EventType, TaskType

metadata = sa.MetaData(schema='ipa')


organizations = sa.Table(
    'organizations', metadata,
    sa.Column('org_id', sa.BigInteger(), primary_key=True),
    sa.Column('revision', sa.BigInteger()),
)


users = sa.Table(
    'users', metadata,
    sa.Column('user_id', sa.BigInteger(), primary_key=True),
    sa.Column('uid', sa.BigInteger()),
    sa.Column('suid', sa.BigInteger()),
    sa.Column('org_id', sa.BigInteger()),
    sa.Column('login', sa.Text()),
    sa.Column('error', sa.Text()),
    sa.Column('created_at', sa.DateTime(timezone=True)),
    sa.Column('modified_at', sa.DateTime(timezone=True)),
)


collectors = sa.Table(
    'collectors', metadata,
    sa.Column('collector_id', sa.BigInteger(), primary_key=True),
    sa.Column('user_id', sa.BigInteger()),
    sa.Column('pop_id', sa.BigInteger()),
    sa.Column('enabled', sa.Boolean()),

    sa.Column('params', JSONB()),

    sa.Column('total', sa.Integer()),
    sa.Column('collected', sa.Integer()),
    sa.Column('errors', sa.Integer()),
    sa.Column('status', sa.Text()),
    sa.Column('checked_at', sa.DateTime(timezone=True)),
    sa.Column('modified_at', sa.DateTime(timezone=True)),
    sa.Column('created_at', sa.DateTime(timezone=True)),
)


tasks = sa.Table(
    'tasks', metadata,
    sa.Column('task_id', sa.BigInteger(), primary_key=True),
    sa.Column('task_type', get_task_type(metadata, TaskType)),
    sa.Column('entity_id', sa.BigInteger()),
    sa.Column('meta_task_id', sa.BigInteger()),
    sa.Column('meta_info', JSONB()),
    sa.Column('state', get_task_state(metadata)),
    sa.Column('action_name', sa.Text()),
    sa.Column('params', JSONB()),
    sa.Column('details', JSONB()),
    sa.Column('retries', sa.Integer(), default=0),
    sa.Column('run_at', sa.DateTime(timezone=True)),
    sa.Column('created', sa.DateTime(timezone=True)),
    sa.Column('updated', sa.DateTime(timezone=True)),
)


event_type = sa.Enum(EventType, name='event_type', metadata=metadata, values_callable=enum_values)


events = sa.Table(
    'events', metadata,
    sa.Column('event_id', sa.BigInteger(), primary_key=True),
    sa.Column('event_type', event_type),
    sa.Column('org_id', sa.BigInteger()),
    sa.Column('revision', sa.BigInteger()),
    sa.Column('data', JSONB()),
    sa.Column('created_at', sa.DateTime(timezone=True)),
)
