from typing import Optional

from sendr_aiopg.data_mapper import SelectableDataMapper, TableDataDumper

from mail.ipa.ipa.core.entities.collector import Collector
from mail.ipa.ipa.core.entities.import_params import ImportParams
from mail.ipa.ipa.storage.db.tables import collectors as t_collectors


class CollectorDataMapper(SelectableDataMapper):
    entity_class = Collector
    selectable = t_collectors

    def map_params(self, params: Optional[dict]) -> Optional[ImportParams]:
        if params is None:
            return None
        return ImportParams(**params)


class CollectorDataDumper(TableDataDumper):
    entity_class = Collector
    table = t_collectors
