from datetime import timedelta

from sendr_taskqueue.worker.storage.db.mappers.worker import get_worker_mapper

from sqlalchemy import and_, func, select, text

from mail.ipa.ipa.core.entities.enums import WorkerState, WorkerType
from mail.ipa.ipa.storage.db.tables import metadata

BaseWorkerMapper = get_worker_mapper(metadata=metadata,
                                     worker_type_cls=WorkerType,
                                     )


class WorkerMapper(BaseWorkerMapper):
    async def clean_old_workers(self, last_heartbeat_age: timedelta, limit: int = 1000) -> None:
        t_workers = self._builder.base
        seconds: float = last_heartbeat_age.total_seconds()

        query = (
            t_workers.delete().
            where(
                t_workers.c.worker_id.in_(
                    select((t_workers.c.worker_id,)).
                    select_from(t_workers).
                    where(
                        and_(
                            t_workers.c.state == WorkerState.CLEANEDUP,
                            t_workers.c.heartbeat < func.now().op('-')(text(f"interval '{seconds} seconds'")),
                            t_workers.c.task_id.is_(None),  # На всякий случай
                        )
                    )
                    .limit(limit)
                )
            )
        )
        await self.conn.execute(query)
