from typing import Any

from aiohttp import web

from sendr_aiopg.types import EngineUnion
from sendr_qlog.http.aiohttp import get_middleware_logging_adapter
from sendr_taskqueue import BaseStorageWorkerApplication

from mail.ipa.ipa.api.routes.utility import UTILITY_ROUTES
from mail.ipa.ipa.conf import settings
from mail.ipa.ipa.interactions.base import BaseInteractionClient, create_connector
from mail.ipa.ipa.taskq.arbiter import ArbiterWorker
from mail.ipa.ipa.taskq.collector import CollectorWorker
from mail.ipa.ipa.taskq.organization import OrganizationWorker
from mail.ipa.ipa.taskq.user import UserWorker
from mail.ipa.ipa.utils.db import create_configured_engine


class IpaWorkerApplication(BaseStorageWorkerApplication):
    debug = settings.DEBUG
    arbiter_cls = ArbiterWorker
    sentry_dsn = settings.SENTRY_DSN
    middlewares = (
        get_middleware_logging_adapter(),
    )
    routes = UTILITY_ROUTES
    workers = [
        (OrganizationWorker, settings.TASKQ_ORGANIZATION_WORKERS),
        (UserWorker, settings.TASKQ_USER_WORKERS),
        (CollectorWorker, settings.TASKQ_COLLECTOR_WORKERS),
    ]

    async def create_connector(self, _: Any) -> None:
        BaseInteractionClient.CONNECTOR = create_connector()

    async def close_connector(self, _: Any) -> None:
        await BaseInteractionClient.close_connector()

    async def setup(self, app: web.Application) -> None:
        await super().setup(app)
        await self.create_connector(app)
        self.on_cleanup.append(self.close_connector)

    async def open_engine(self) -> EngineUnion:
        db_engine = create_configured_engine()
        await db_engine.connect()
        return db_engine
