from mail.ipa.ipa.core.actions.import_.csv import ParseCSVAction
from mail.ipa.ipa.core.actions.import_.org import InitOrgImportAction
from mail.ipa.ipa.core.actions.import_.stop import StopOrgImportAction
from mail.ipa.ipa.core.entities.enums import TaskType, WorkerType
from mail.ipa.ipa.core.entities.task import Task
from mail.ipa.ipa.storage import Storage
from mail.ipa.ipa.storage.mappers.task import TaskMapper
from mail.ipa.ipa.taskq.base import BaseWorker


class OrganizationWorker(BaseWorker):
    worker_type = WorkerType.ORGANIZATION
    task_action_mapping = {
        TaskType.PARSE_CSV: ParseCSVAction,
        TaskType.INIT_IMPORT: InitOrgImportAction,
        TaskType.STOP_IMPORT: StopOrgImportAction,
    }

    async def fetch_task_for_work(self, storage: Storage) -> Task:
        task_mapper: TaskMapper = storage[self.mapper_name_task]

        task = await task_mapper.get_org_task_for_work(task_types=self.task_types)
        return task
