import asyncio
import logging
import uuid

from sendr_qlog import LoggerContext

from mail.ipa.ipa.conf import settings
from mail.ipa.ipa.core.actions.base import BaseAction
from mail.ipa.ipa.interactions import InteractionClients
from mail.ipa.ipa.interactions.base import BaseInteractionClient, create_connector
from mail.ipa.ipa.storage import Storage
from mail.ipa.ipa.utils.db import create_configured_engine
from mail.ipa.ipa.utils.logging import configure_logging


def create_shell_context():
    # TODO: починить python-prompt-toolkit
    # asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    loop = asyncio.get_event_loop()
    configure_logging()

    BaseInteractionClient.CONNECTOR = create_connector()
    request_id = 'manual_' + uuid.uuid4().hex
    logger = LoggerContext(logging.getLogger(), {'request_id': request_id})
    clients = InteractionClients(logger, request_id)

    db_engine = create_configured_engine()
    loop.run_until_complete(db_engine.connect())

    conn = loop.run_until_complete(db_engine.acquire().__aenter__())
    storage = Storage(conn)

    BaseAction.context.logger = logger
    BaseAction.context.request_id = request_id
    BaseAction.context.db_engine = db_engine

    return {
        'clients': clients,
        'db_engine': db_engine,
        'logger': logger,
        'request_id': request_id,
        'settings': settings,
        'storage': storage,
    }
