from typing import Any, Dict

from sendr_aiopg.engine.multiple import MultipleEngine, create_engine

from mail.ipa.ipa.conf import settings


def get_db_configuration():
    return {
        'database': settings.DATABASE['NAME'],
        'user': settings.DATABASE['USER'],
        'password': settings.DATABASE['PASSWORD'],
        'host': settings.DATABASE['HOST'],
        'port': settings.DATABASE['PORT'],
        'sslmode': 'require' if settings.DATABASE.get('USE_SSL') else 'disable',
        'connect_timeout': settings.DB_CONNECT_TIMEOUT,
        'timeout': settings.DB_TIMEOUT,
        'minsize': settings.DATABASE.get('MINSIZE', 1),
        'maxsize': settings.DATABASE.get('MAXSIZE', 10),
    }


def create_configured_engine() -> MultipleEngine:  # pragma: no cover
    config: Dict[str, Any] = dict()

    for target_session_attrs in ('read-write', 'any'):
        config[target_session_attrs] = dict(
            **get_db_configuration(),
            target_session_attrs=target_session_attrs,
        )

    return create_engine(config, default='read-write')
