from typing import AsyncIterable, AsyncIterator, Callable, Iterable, List, TypeVar, Union

_T1 = TypeVar('_T1')
_T2 = TypeVar('_T2')


def merge_lists(list1: List[_T1], list2: List[_T2], less: Callable[[_T1, _T2], bool]) -> Iterable[Union[_T1, _T2]]:
    index1 = index2 = 0
    while index1 < len(list1) and index2 < len(list2):
        if less(list1[index1], list2[index2]):
            yield list1[index1]
            index1 += 1
        else:
            yield list2[index2]
            index2 += 1
    yield from list1[index1:]
    yield from list2[index2:]


def aiter(iterable: AsyncIterable[_T1]) -> AsyncIterator[_T1]:
    return iterable.__aiter__()
