from sendr_qstats import AggSuff, Counter, Gauge, Histogram, IntSuff, MetricsRegistry, MetricSuffix

from mail.ipa.ipa.conf import settings

REGISTRY = MetricsRegistry(ctype=settings.get('STATS_CTYPE'))

ABS_MAX_SUFF = MetricSuffix(
    IntSuff.absolute.value,
    AggSuff.max.value,
    AggSuff.max.value,
    AggSuff.trnsp.value,
)


interaction_response_time = Histogram(
    'response_time',
    buckets=settings.STATS_RESPONSE_TIME_BUCKETS,
    labelnames=('service',),
    registry=REGISTRY,
)
interaction_response_status = Counter(
    'response_status',
    labelnames=('service', 'status'),
    registry=REGISTRY,
)

interaction_method_response_time = Histogram(
    'response_method_time',
    buckets=settings.STATS_RESPONSE_TIME_BUCKETS,
    labelnames=('service', 'method'),
    registry=REGISTRY,
)
interaction_method_response_status = Counter(
    'response_method_status',
    labelnames=('service', 'method', 'status'),
    registry=REGISTRY,
)

queue_tasks_counter = Counter('queue_tasks_counter', labelnames=('status',), registry=REGISTRY)
queue_tasks_time = Histogram(
    'queue_tasks_time',
    labelnames=('worker',),
    buckets=settings.TASK_BUCKETS,
    registry=REGISTRY
)

queue_tasks_gauge = Gauge(
    'pending_tasks',
    labelnames=('task_type',),
    suff=ABS_MAX_SUFF,
    registry=REGISTRY,
)

queue_size_gauge = Gauge('queue_size', suff='_axxt', labelnames=(), registry=REGISTRY)

collector_check_period_gauge = Gauge('collector_check_period', suff='_axxt', labelnames=(), registry=REGISTRY)
