OWNER(g:mail-swat)

PY3_LIBRARY()

PEERDIR(
    contrib/python/chardet
    contrib/python/cryptography
    contrib/python/marshmallow-enum/py2
    contrib/python/typing-extensions
    contrib/python/uvloop
    contrib/python/xmltodict
    library/python/resource
    mail/python/sendr-qtools
)

PY_SRCS(
    api/app.py
    api/exceptions.py
    api/handlers/base.py
    api/handlers/import_.py
    api/handlers/support.py
    api/handlers/tasks.py
    api/handlers/utility.py
    api/middlewares.py
    api/routes/routes.py
    api/routes/utility.py
    api/schemas/base.py
    api/schemas/common.py
    api/schemas/import_.py
    api/schemas/path.py
    api/schemas/support.py
    api/schemas/tasks.py
    api/schemas/user.py
    commands/__init__.py
    commands/generate_ammo.py
    commands/runserver.py
    commands/runworkers.py
    conf.py
    core/actions/base.py
    core/actions/collectors/check.py
    core/actions/collectors/edit.py
    core/actions/collectors/get.py
    core/actions/collectors/get_list.py
    core/actions/collectors/get_statuses.py
    core/actions/collectors/inherit.py
    core/actions/collectors/init.py
    core/actions/collectors/remove.py
    core/actions/collectors/set_enabled.py
    core/actions/events/get_list.py
    core/actions/import_/base.py
    core/actions/import_/csv.py
    core/actions/import_/json.py
    core/actions/import_/org.py
    core/actions/import_/stop.py
    core/actions/import_/user.py
    core/actions/ping_db.py
    core/actions/report.py
    core/actions/stats/info.py
    core/actions/stats/summary.py
    core/actions/tasks.py
    core/actions/users/get_list.py
    core/actions/users/init.py
    core/actions/users/remove_collectors.py
    core/context.py
    core/crypto/__init__.py
    core/crypto/base.py
    core/crypto/versioned.py
    core/crypto/fernet.py
    core/csvops/__init__.py
    core/csvops/base.py
    core/csvops/linereader.py
    core/csvops/sniffer.py
    core/entities/collector.py
    core/entities/csv.py
    core/entities/enums.py
    core/entities/event.py
    core/entities/import_params.py
    core/entities/not_fetched.py
    core/entities/org.py
    core/entities/password.py
    core/entities/stat.py
    core/entities/task.py
    core/entities/user_info.py
    core/entities/user.py
    core/exceptions.py
    __init__.py
    interactions/base.py
    interactions/blackbox/exceptions.py
    interactions/blackbox/__init__.py
    interactions/directory/entities.py
    interactions/directory/exceptions.py
    interactions/directory/__init__.py
    interactions/exceptions.py
    interactions/__init__.py
    interactions/mds/exceptions.py
    interactions/mds/__init__.py
    interactions/yarm/entities.py
    interactions/yarm/exceptions.py
    interactions/yarm/__init__.py
    manage.py
    storage/db/tables.py
    storage/exceptions.py
    storage/gateways/base.py
    storage/gateways/stat.py
    storage/__init__.py
    storage/mappers/base.py
    storage/mappers/collector/mapper.py
    storage/mappers/collector/serialization.py
    storage/mappers/event.py
    storage/mappers/organization.py
    storage/mappers/task.py
    storage/mappers/user/mapper.py
    storage/mappers/user/serialization.py
    storage/mappers/worker.py
    taskq/app.py
    taskq/arbiter.py
    taskq/base.py
    taskq/collector.py
    taskq/organization.py
    taskq/user.py
    utils/cli.py
    utils/db.py
    utils/helpers.py
    utils/logging.py
    utils/stats.py
    utils/tvm.py
)

RESOURCE_FILES(
    settings/000-logging.conf
    settings/010-common.conf
    settings/010-common.conf.production
    settings/020-database.conf
    settings/020-database.conf.development
    settings/020-database.conf.testing
    settings/030-interactions.conf
    settings/030-interactions.conf.load
    settings/030-interactions.conf.production
    settings/030-interactions.conf.qa
    settings/040-tvm.conf
    settings/040-tvm.conf.development
    settings/040-tvm.conf.load
    settings/040-tvm.conf.production
    settings/040-tvm.conf.qa
    settings/050-taskq.conf
    settings/050-taskq.conf.load
    settings/050-taskq.conf.production
    settings/060-csv.conf
    settings/070-cryptography.conf
)

END()

RECURSE_FOR_TESTS(tests)
