ALTER TABLE ipa.organizations ADD COLUMN revision BIGINT NOT NULL DEFAULT 1;

CREATE TYPE ipa.event_type as enum ('start', 'stop');

CREATE TABLE ipa.events
(
    event_id BIGSERIAL NOT NULL CONSTRAINT events_pkey PRIMARY KEY,
    event_type ipa.event_type NOT NULL,
    org_id BIGINT NOT NULL REFERENCES ipa.organizations,
    revision BIGINT NOT NULL DEFAULT 1,
    data JSONB NOT NULL DEFAULT '{}'::JSONB,
    created_at TIMESTAMPTZ NOT NULL DEFAULT NOW()
);

create index events_org_id_idx on ipa.events (org_id, event_type, event_id);
