ALTER TABLE ipa.users ADD COLUMN mail_migrations bigint[] NOT NULL DEFAULT array[]::bigint[];

CREATE INDEX users_mail_migrations_idx ON ipa.users USING GIN (mail_migrations);

CREATE TYPE ipa.migration_status AS enum ('active', 'paused', 'finished');

CREATE TABLE ipa.migrations
(
    id bigserial PRIMARY KEY,
    org_id bigint NOT NULL,
    admin_uid bigint NOT NULL,
    title text NOT NULL,
    current_status ipa.migration_status NOT NULL DEFAULT 'active',
    target_status ipa.migration_status NOT NULL DEFAULT 'active',
    mail_settings jsonb,
    created_at timestamp with time zone NOT NULL DEFAULT current_timestamp,

    CONSTRAINT uk_migration_name
        UNIQUE (org_id, title)
);
