#!/usr/bin/env bash

self_tvm_id=2017079

if [ -n "$self_tvm_id" ]
then
    export PYTHONPATH=./src
    export QLOUD_TVM_SECRET=$(cat ./.tvm.key)

    [[ -f ./.tvm.port ]] || echo $(( (RANDOM % 100) + 33300 )) > ./.tvm.port
    export QLOUD_TVM_PORT=$(cat ./.tvm.port)

    export QLOUD_TVM_INTERFACE_ORIGIN="http://localhost:$QLOUD_TVM_PORT"
    export QLOUD_TVM_TOKEN=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
    export QLOUD_TVM_CONFIG=$(
        jq -n --arg secret "$QLOUD_TVM_SECRET" --argjson self_tvm_id "$self_tvm_id" '{
            "BbEnvType": 0,
            "clients": {
                "ipa": {
                    "secret": $secret,
                    "self_tvm_id": $self_tvm_id,
                    "dsts": {
                        "ipa": {
                            "dst_id": $self_tvm_id
                        },
                        "blackbox": {
                            "dst_id": 224
                        },
                        "directory": {
                            "dst_id": 2000204
                        },
                        "mds": {
                            "dst_id": 2000272
                        }
                    }
                }
            }
        }'
    )

    echo $QLOUD_TVM_CONFIG > .tvm.json
    # clean up prev. tvmtool run
    pkill -f "tvmtool.*$QLOUD_TVM_PORT" || true
    tvmtool --port $QLOUD_TVM_PORT -a $QLOUD_TVM_TOKEN -c .tvm.json > /dev/null &
fi

make start_db

while [ "$1" != "" ]; do
    case $1 in
        -w  )
            shift
            exec watchmedo auto-restart -R -p "*.py;*.conf;*ya.make" -- "$@"
                                ;;
        * )
            exec "$@"
    esac
    shift
done
