package ru.yandex.mail.diffusion;

import ru.yandex.mail.diffusion.generator.CodeGenerator;
import ru.yandex.mail.diffusion.generator.Proxies;
import ru.yandex.mail.diffusion.patch.PatchApplier;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Diffusion {
    private final CodeGenerator codeGenerator;
    private final Map<Class, Proxies> proxiesMap;

    public Diffusion() {
        codeGenerator = new CodeGenerator();
        proxiesMap = new ConcurrentHashMap<>();
    }

    private <T> Proxies<T> createProxies(Class<T> type) {
        return codeGenerator.process(type);
    }

    @SuppressWarnings("unchecked")
    private <T> Proxies<T> getProxies(Class<T> type) {
        return (Proxies<T>) proxiesMap.computeIfAbsent(type, this::createProxies);
    }

    public <T> FieldMatcher<T> fieldMatcherFor(Class<T> type) {
        return getProxies(type).getFieldMatcher();
    }

    public <T> PatchApplier<T> patchApplierFor(Class<T> type) {
        return getProxies(type).getPatchApplier();
    }
}
