package ru.yandex.mail.diffusion.generator;

import javassist.bytecode.SignatureAttribute.ClassSignature;
import javassist.bytecode.SignatureAttribute.ClassType;
import javassist.bytecode.SignatureAttribute.TypeArgument;
import lombok.experimental.UtilityClass;
import lombok.val;
import one.util.streamex.StreamEx;
import org.apache.commons.text.StringSubstitutor;

import java.util.Map;

@UtilityClass
class Utils {
    static ClassSignature createGenericSignature(String baseType, String... parameterTypes) {
        val generics = StreamEx.of(parameterTypes)
            .map(ClassType::new)
            .map(TypeArgument::new)
            .toArray(TypeArgument[]::new);

        val incrementalTypeInfoType = new ClassType(baseType, generics);
        return new ClassSignature(null, null, new ClassType[] { incrementalTypeInfoType });
    }

    @SafeVarargs
    static String format(String template, Map.Entry<String, Object>... entries) {
        return new StringSubstitutor(Map.ofEntries(entries)).replace(template);
    }
}
