package ru.yandex.mail.diffusion.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import one.util.streamex.StreamEx;
import ru.yandex.mail.diffusion.patch.FieldChange;
import ru.yandex.mail.diffusion.patch.PatchProvider;

public class JsonPatchProvider implements PatchProvider {
    private final ObjectMapper objectMapper;
    private final JsonNode patch;

    public JsonPatchProvider(ObjectMapper objectMapper, JsonNode patch) {
        this.objectMapper = objectMapper;
        this.patch = patch;
    }

    @SneakyThrows
    public JsonPatchProvider(ObjectMapper objectMapper, String jsonPatch) {
        this.objectMapper = objectMapper;
        patch = objectMapper.readTree(jsonPatch);
    }

    @Override
    public Iterable<FieldChange> changes() {
        return StreamEx.of(patch.fields())
            .map(entry -> new JsonFieldChange(entry.getValue(), entry.getKey(), objectMapper))
            .map(FieldChange.class::cast)
            .toImmutableList();
    }
}
