package ru.yandex.mail.diffusion.patch;

import one.util.streamex.StreamEx;
import ru.yandex.mail.diffusion.FieldMatcher;

public class CompositePatchCollector<P> implements PatchCollector<P[]> {
    private final PatchCollector<P>[] collectors;

    @SafeVarargs
    public CompositePatchCollector(PatchCollector<P>... collectors) {
        this.collectors = collectors;
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> P[] collect(T oldObject, T newObject, FieldMatcher<T> matcher) {
        return (P[]) StreamEx.of(collectors)
            .map(collector -> collector.collect(oldObject, newObject, matcher))
            .toArray();
    }
}
