package ru.yandex.mail.diffusion.patch;

import lombok.Value;
import lombok.experimental.UtilityClass;
import one.util.streamex.StreamEx;

import java.util.Set;

import static java.util.Collections.emptySet;
import static java.util.function.Predicate.not;

@UtilityClass
public class DiffUtils {
    @Value
    public static class Diff<T> {
        Set<T> added;
        Set<T> removed;

        public boolean isEmpty() {
            return added.isEmpty() && removed.isEmpty();
        }

        public static <T> Diff<T> empty() {
            return new Diff<>(emptySet(), emptySet());
        }
    }

    private static <T> Set<T> findAbsent(Set<T> from, Set<T> in) {
        return StreamEx.of(from)
            .filter(not(in::contains))
            .toSet();
    }

    public static <T> Diff<T> findDiff(Set<T> from, Set<T> to) {
        return new Diff<>(
            findAbsent(to, from),
            findAbsent(from, to)
        );
    }
}
