package ru.yandex.mail.diffusion.patch.exception;

import com.fasterxml.jackson.databind.node.JsonNodeType;
import one.util.streamex.StreamEx;

public class UnexpectedTypeException extends PatchException {
    private static String join(JsonNodeType[] expectedTypes) {
        return StreamEx.of(expectedTypes).joining(" or ");
    }

    public UnexpectedTypeException(String fieldName, JsonNodeType[] expectedTypes, JsonNodeType actualType) {
        super("Unexpected field '" + fieldName + "' type, expected: '" + join(expectedTypes) +
            "', got: '" + actualType + '\'');
    }
}
