package ru.yandex.autotests.innerpochta.yfurita.util;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.path.xml.XmlPath;
import com.jayway.restassured.path.xml.element.Node;
import com.jayway.restassured.path.xml.element.NodeChildren;

import java.util.*;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static ru.yandex.autotests.innerpochta.yfurita.util.FuritaConsts.*;
import static ru.yandex.autotests.innerpochta.yfurita.util.YfuritaProperties.yfuritaProps;

/**
 * User: stassiak
 */
public class FilterSettings {
    HashMap<String, String> params = new HashMap<String, String>();

    public static final String[] TEST_LABELS = {"test1", "test2", "11,22", "priority_high"/*Важные*/};
    public static final String TEST_FOLDER = "test1";
    public static final String[] DEFAULT_FOLDERS = {TEST_FOLDER, PG_FOLDER_DEFAULT, PG_FOLDER_OUTBOX,
            PG_FOLDER_DELETED, PG_FOLDER_DRAFT, PG_FOLDER_SPAM};
    public static final String[] DEFAULT_FOLDERS_PG = {TEST_FOLDER, "Inbox",/**"Outbox",*/"Trash", "Drafts", "Spam"};

    public FilterSettings() {
        setDefaultFilterParams();
    }

    public HashMap<String, String> getParams() {
        return params;
    }

    public static HashMap<String, String> getSettings(JsonPath jsonPath) {
        return getSettings(jsonPath, 0);
    }

    public static HashMap<String, String> getSettings(JsonPath jsonPath, int ruleNumber) {
        HashMap<String, String> settings = new HashMap<String, String>();

        //parse stop value
        settings.put("stop", jsonPath.getBoolean("rules[" + ruleNumber + "].stop") ? "1" : "0");
        settings.put("name", jsonPath.getString("rules[" + ruleNumber + "].name"));

        String actionType = jsonPath.getString("rules[" + ruleNumber + "].actions[0].type");
        settings.put("clicker", actionType);

        if (FilterSettings.actionsWithNotifyEnum.contains(actionType)) {
            if (jsonPath.getBoolean("rules[" + ruleNumber + "].actions[0].verified")) {
                settings.put("noconfirm", "1");
            }

            if (actionType.equals(FilterSettings.CLIKER_NOTIFY)) {
                settings.put("notify_address", jsonPath.getString("rules[" + ruleNumber + "].actions[0].parameter"));
            } else {
                settings.put("forward_address", jsonPath.getString("rules[" + ruleNumber + "].actions[0].parameter"));
            }

        } else {
            if (actionType.equals(FilterSettings.CLIKER_MOVE)) {

                settings.put("move_folder", jsonPath.getString("rules[" + ruleNumber + "].actions[0].parameter"));

            } else if (actionType.equals(FilterSettings.CLIKER_MOVEL)) {

                settings.put("move_label", jsonPath.getString("rules[" + ruleNumber + "].actions[0].parameter"));

            } else if (actionType.equals(FilterSettings.CLIKER_REPLY)) {

                settings.put("autoanswer", jsonPath.getString("rules[" + ruleNumber + "].actions[0].parameter"));

            }
        }
        for (int i = 0; i < jsonPath.getList("rules[" + ruleNumber + "].conditions").size(); i++) {
            if (jsonPath.getString("rules[" + ruleNumber + "].conditions[" + i + "].pattern") == null) {
                String field = jsonPath.getString("rules[" + ruleNumber + "].conditions[" + i + "].div");
                if (field.equals("att")) {

                    settings.put("attachment",
                            jsonPath.getString("rules[" + ruleNumber + "].conditions[" + i + "].oper"));

                } else {

                    settings.put("letter", field);
                }

            } else {

                settings.put("field1", jsonPath.getString("rules[" + ruleNumber + "].conditions[" + i + "].div"));
                settings.put("field3", jsonPath.getString("rules[" + ruleNumber + "].conditions[" + i + "].pattern"));
                settings.put("field2", jsonPath.getString("rules[" + ruleNumber + "].conditions[" + i + "].oper"));
                settings.put("logic", jsonPath.getString("rules[" + ruleNumber + "].conditions[" + i + "].link"));

            }
        }


        return settings;
    }

    public static HashMap<String, String> getSettings(XmlPath xmlPath) {
        return getSettings(xmlPath.get().children().get(0));
    }

    public static HashMap<String, String> getSettings(Node ruleNode) {
        HashMap<String, String> settings = new HashMap<String, String>();

        //parse stop value
        settings.put("stop", ruleNode.getAttribute("stop"));
        settings.put("name", ruleNode.getAttribute("name"));

        NodeChildren rule = ruleNode.children();
        for (Node node : rule.list()) {

            if (node.name().equals("name")) {

                settings.put("name", node.value().trim());

            }

            if (node.name().equals("action")) {

                String actionType = node.getAttribute("type");
                settings.put("clicker", actionType);
                if (FilterSettings.actionsWithNotifyEnum.contains(actionType)) {
                    if (node.getAttribute("verified").equals("1")) {

                        settings.put("noconfirm", "1");

                    }
                }

                Node parameter = node.getNode("parameter");

                if (FilterSettings.actionsWithNotifyEnum.contains(actionType)) {

                    if (actionType.equals(FilterSettings.CLIKER_NOTIFY)) {

                        settings.put("notify_address", parameter.value().trim());

                    } else {

                        settings.put("forward_address", parameter.value().trim());

                    }

                } else {
                    if (actionType.equals(FilterSettings.CLIKER_MOVE)) {

                        settings.put("move_folder", parameter.value().trim());

                    } else if (actionType.equals(FilterSettings.CLIKER_MOVEL)) {

                        settings.put("move_label", parameter.value().trim());

                    } else if (actionType.equals(FilterSettings.CLIKER_REPLY)) {

                        settings.put("autoanswer", parameter.value().trim());

                    }
                }

            }

            if (node.name().equals("condition")) {

                if (node.getNode("pattern") == null) {

                    String value = node.getAttribute("div").trim();
                    if (value.equals("att")) {

                        settings.put("attachment", node.getAttribute("oper"));

                    } else {

                        settings.put("letter", value);
                    }

                } else {

                    settings.put("field1", node.getAttribute("div").trim());
                    settings.put("field3", node.getNode("pattern").value().trim());
                    settings.put("field2", node.getAttribute("oper"));
                    settings.put("logic", node.getAttribute("link"));

                }
            }
        }

        return settings;
    }

    public static HashMap<String, HashMap<String, String>> getShortFiltersSettingsList(
            HashMap<String, HashMap<String, String>> paramsList) {

        HashMap<String, HashMap<String, String>> shortParamsList = new HashMap<String, HashMap<String, String>>();

        for (String filterId : paramsList.keySet()) {
            shortParamsList.put(filterId, getShortFilterSettins(paramsList.get(filterId)));
        }

        return shortParamsList;
    }

    public static HashMap<String, String> getShortFilterSettins(HashMap<String, String> params) {
        HashMap<String, String> shortParams = new HashMap<String, String>();
        shortParams.put("name", params.get("name"));
        shortParams.put("clicker", params.get("clicker"));
        shortParams.put("stop", params.get("stop"));
        if (params.containsKey("noconfirm")) {
            shortParams.put("noconfirm", params.get("noconfirm"));
        }
        if (params.containsKey("notify_address")) {
            shortParams.put("notify_address", params.get("notify_address"));
        }
        if (params.containsKey("move_folder")) {
            shortParams.put("move_folder", params.get("move_folder"));
        }
        if (params.containsKey("move_label")) {
            shortParams.put("move_label", params.get("move_label"));
        }
        if (params.containsKey("autoanswer")) {
            shortParams.put("autoanswer", params.get("autoanswer"));
        }
        if (params.containsKey("forward_address")) {
            shortParams.put("forward_address", params.get("forward_address"));
        }

        return shortParams;
    }

    public static Collection<Object[]> dataForComplicatedLogicTest() throws Exception {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        addComplicatedLogicTest(testCases);
        return testCases;
    }

    private static void addComplicatedLogicTest(ArrayList<Object[]> testCases) {
    }


    public static Collection<Object[]> dataForCreateTest(FilterUser user) throws Exception {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        addClikerFieldTests(testCases, user);       //0-21
        addConditionFieldTests(testCases);    //22-57
        addLetterFieldTests(testCases);       //58-60
        addLogicFieldTests(testCases);        //61-62
        addOrderAndStopFieldsTests(testCases);//63-66*/
        addCommaInFieldTest(testCases); //67
        addAttachmentFieldsTests(testCases);//68-70
        if (!yfuritaProps().isCorp()) {
            addNoConfirmFieldTest(testCases);//71
        }
        return testCases;
    }

    public static Collection<Object[]> dataForEditTest(FilterUser user) throws Exception {
        ArrayList<Object[]> dataForCreate = (ArrayList<Object[]>) dataForCreateTest(user);
        ArrayList<Object[]> dataForEdit = (ArrayList<Object[]>) dataForCreateTest(user);

        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        for (int i = 0; i < dataForCreate.size(); i++) {
            testCases.add(new Object[]{dataForCreate.get(i)[0], dataForEdit.get(i)[0]});
        }

        return testCases;
    }

    public static void addNoConfirmFieldTest(ArrayList<Object[]> testCases) {
        for (String action : actionsWithNotifyEnum) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLetter(LETTER_NOSPAM);
            filterSettings.setClicker(action);
            if (action.equals(CLIKER_NOTIFY)) {
                filterSettings.setNotifyAddress(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".tr");
            } else {
                filterSettings.setForwardAddress(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".tr");
            }
            filterSettings.setLogic(LOGIC_OR);
            filterSettings.setStop(STOP_YES);
            filterSettings.setNoConfirm();

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    private static void addAttachmentFieldsTests(ArrayList<Object[]> testCases) {
        for (String attach : attachEnum) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setAttach(attach);

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    /**
     * DARIA-15305
     * Проверка создания фильтра с запятой в условии совпадения
     *
     * @param testCases - списко фильтров, куда добавляем этот фильтр
     */
    public static void addCommaInFieldTest(ArrayList<Object[]> testCases) {
        FilterSettings filterSettings = new FilterSettings();
        filterSettings.setLetter(LETTER_NOSPAM);
        filterSettings.setOrder(ORDER_FIRST);
        filterSettings.setStop(STOP_YES);
        filterSettings.setField3("111, 222");

        testCases.add(new Object[]{filterSettings.params});
    }

    private static void addConditionFieldTests(ArrayList<Object[]> testCases) {

        for (String field1 : field1Enum) {
            for (String field2 : field2Enum) {
                FilterSettings filterSettings = new FilterSettings();
                filterSettings.setField1(field1);
                filterSettings.setField2(field2);
                filterSettings.setField3(randomAlphanumeric(8) + "@ya.ru");

                testCases.add(new Object[]{filterSettings.params});
            }
        }
    }

    private static void addOrderAndStopFieldsTests(ArrayList<Object[]> testCases) {
        for (String stop : stopEnum) {
            for (String order : oderEnum) {
                FilterSettings filterSettings = new FilterSettings();
                filterSettings.setStop(stop);
                filterSettings.setOrder(order);

                testCases.add(new Object[]{filterSettings.params});
            }
        }
    }

    private static void addClikerFieldTests(ArrayList<Object[]> testCases, FilterUser user) {
        clikerEqualsMove(testCases, user);
        clikerEqualsMovel(testCases, user);
        clikerEqualsDelete(testCases);
        clikerEqualsReply(testCases);
        if (!yfuritaProps().isCorp()) {
            clikerEqualsForward(testCases);
            clikerEqualsForwardWithStore(testCases);
        }
        clikerEqualsNotify(testCases);
    }

    private static void clikerEqualsNotify(ArrayList<Object[]> testCases) {
        for (String lang : langEnum) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLetter(LETTER_NOSPAM);
            filterSettings.setClicker(CLIKER_NOTIFY);
            filterSettings.setNotifyAddress(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".tr");
            filterSettings.setLogic(LOGIC_OR);
            filterSettings.setStop(STOP_YES);
            filterSettings.setFromConfirm(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".tr");
            filterSettings.setConfirmLang(lang);
            filterSettings.setConfirmDomain("mail.yandex.com.tr");
            filterSettings.setAuthDomain("yandex.com.tr");

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    private static void clikerEqualsForwardWithStore(ArrayList<Object[]> testCases) {
        for (String confirmDomain : confirmDomainEnum) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLetter(LETTER_NOSPAM);
            filterSettings.setClicker(CLIKER_FORWARD_WITH_STORE);
            filterSettings.setForwardAddress(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".com");
            filterSettings.setLogic(LOGIC_OR);
            filterSettings.setStop(STOP_YES);
            filterSettings.setFromConfirm(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".com");
            filterSettings.setConfirmLang(LANG_EN);
            filterSettings.setConfirmDomain(confirmDomain);
            filterSettings.setAuthDomain("yandex.com");

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    private static void clikerEqualsForward(ArrayList<Object[]> testCases) {
        for (String authDomain : authDomainEnum) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLetter(LETTER_NOSPAM);
            filterSettings.setClicker(CLIKER_FORWARD);
            filterSettings.setForwardAddress(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".ru");
            filterSettings.setLogic(LOGIC_OR);
            filterSettings.setStop(STOP_YES);
            filterSettings.setFromConfirm(randomAlphanumeric(5) + "@" + randomAlphanumeric(3) + ".ru");
            filterSettings.setConfirmLang(LANG_RU);
            filterSettings.setConfirmDomain(CONFIRM_DOMAIN_YANDEX_RU);
            filterSettings.setAuthDomain(authDomain);

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    private static void clikerEqualsReply(ArrayList<Object[]> testCases) {
        FilterSettings filterSettings = new FilterSettings();
        filterSettings.setLetter(LETTER_NOSPAM);
        filterSettings.setLogic(LOGIC_OR);
        filterSettings.setClicker(CLIKER_REPLY);
        filterSettings.setAutoAnswer(randomAlphanumeric(7));
        filterSettings.setStop(STOP_YES);

        testCases.add(new Object[]{filterSettings.params});
    }

    private static void clikerEqualsDelete(ArrayList<Object[]> testCases) {
        FilterSettings filterSettings = new FilterSettings();
        filterSettings.setLetter(LETTER_NOSPAM);
        filterSettings.setLogic(LOGIC_OR);
        filterSettings.setStop(STOP_YES);

        testCases.add(new Object[]{filterSettings.params});
    }

    private static void clikerEqualsMovel(ArrayList<Object[]> testCases, FilterUser user) {
        for (String label : TEST_LABELS) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLetter(LETTER_NOSPAM);
            filterSettings.setLogic(LOGIC_OR);
            filterSettings.setClicker(CLIKER_MOVEL);
            filterSettings.setMoveLabel(user.getLid(label));

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    private static void clikerEqualsMove(ArrayList<Object[]> testCases, FilterUser user) {
        for (String folder : yfuritaProps().isCorp() ? DEFAULT_FOLDERS : DEFAULT_FOLDERS_PG) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLetter(LETTER_NOSPAM);
            filterSettings.setLogic(LOGIC_OR);
            filterSettings.setClicker(CLIKER_MOVE);
            filterSettings.setMoveFolder(user.getFid(folder));
            filterSettings.setStop(STOP_YES);

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    private static void addLogicFieldTests(ArrayList<Object[]> testCases) {
        for (String logic : logicEnum) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLogic(logic);
            filterSettings.setOrder(ORDER_FIRST);
            filterSettings.setStop(STOP_YES);

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    private static void addLetterFieldTests(ArrayList<Object[]> testCases) {
        for (String letter : letterEnum) {
            FilterSettings filterSettings = new FilterSettings();
            filterSettings.setLetter(letter);
            filterSettings.setOrder("1");
            filterSettings.setStop("1");

            testCases.add(new Object[]{filterSettings.params});
        }
    }

    public void setDefaultFilterParams() {
        setName(randomAlphanumeric(10));
        setLetter(LETTER_ALL);
        setAttach(ATT_ALL);
        setLogic(LOGIC_AND);
        setField1(FIELD1_FROM);
        setField2(FIELD2_EQUAL);
        setField3(randomAlphanumeric(7) + "@" + randomAlphanumeric(5) + ".ru");
        setClicker(CLIKER_DELETE);
        setOrder(ORDER_LAST);
        setStop(STOP_NO);
    }

    public void setName(String name) {
        params.put("name", name);
    }

    public void setLetter(String value) {
        params.put("letter", value);
    }

    public void setLogic(String value) {
        params.put("logic", value);
    }

    public void setField1(String value) {
        params.put("field1", value);
    }

    public void setField2(String value) {
        params.put("field2", value);
    }

    public void setField3(String value) {
        params.put("field3", value);
    }

    public void setClicker(String value) {
        params.put("clicker", value);
    }

    public void setOrder(String value) {
        params.put("oder", value);
    }

    public void setStop(String value) {
        params.put("stop", value);
    }

    public void setMoveFolder(String value) {
        params.put("move_folder", value);
    }

    public void setMoveLabel(String value) {
        params.put("move_label", value);
    }

    public void setAutoAnswer(String value) {
        params.put("autoanswer", value);
    }

    public void setForwardAddress(String value) {
        params.put("forward_address", value);
    }

    public void setNotifyAddress(String notifyAddress) {
        params.put("notify_address", notifyAddress);
    }

    public void setAttach(String value) {
        params.put("attachment", value);
    }

    public void setFromConfirm(String value) {
        params.put("from", value);
    }

    public void setConfirmLang(String value) {
        params.put("lang", value);
    }

    public void setConfirmDomain(String value) {
        params.put("confirm_domain", value);
    }

    public void setAuthDomain(String value) {
        params.put("auth_domain", value);
    }

    public void setNoConfirm() {
        params.put("noconfirm", NO_CONFIRM);
    }

    // *** Метод фильтрации --------------------------------------------------------------
    public static final String LETTER_ALL = "all";
    public static final String LETTER_NOSPAM = "nospam";
    public static final String LETTER_CLEARSPAM = "clearspam";

    static String[] letterEnum = new String[]{
            LETTER_ALL,
            LETTER_CLEARSPAM,
            LETTER_NOSPAM
    };

    // *** Логика условий --------------------------------------------------------------
    public static final String LOGIC_OR = "0";
    public static final String LOGIC_AND = "1";
    //-

    static String[] logicEnum = new String[]{LOGIC_OR, LOGIC_AND};

    // *** Поле хидера письма (field1) --------------------------------------------------------------
    public static final String FIELD1_FROM = "from";
    public static final String FIELD1_TO = "to";
    public static final String FIELD1_CC = "cc";
    public static final String FIELD1_TOCC = "tocc";
    public static final String FIELD1_SUBJECT = "subject";
    public static final String FIELD1_BODY = "body";
    public static final String FIELD1_FILENAME = "filename";
    public static final String FIELD1_HEADER_DATE = "Date";
    public static final String FIELD1_HEADER_MESSAGE_ID = "Message-ID";
    public static final String FIELD1_HEADER_X_YANDEX_TEST = "X-Yandex-Test";
    //--------------------------------------------------------------

    static String[] field1Enum = new String[]{
            FIELD1_BODY,
            FIELD1_FILENAME,
            FIELD1_FROM,
            FIELD1_SUBJECT,
            FIELD1_TO,
            FIELD1_CC,
            FIELD1_TOCC,
            FIELD1_HEADER_DATE,
            FIELD1_HEADER_MESSAGE_ID,
            FIELD1_HEADER_X_YANDEX_TEST
    };

    // *** ЛОГИКА (field2) --------------------------------------------------------------
    public static final String FIELD2_EQUAL = "1";          // Совпадает
    public static final String FIELD2_NOEQUAL = "2";        // Не совпадает
    public static final String FIELD2_CONTAINS = "3";       // Содержит
    public static final String FIELD2_NOTCONTAINS = "4";    // Не содержит
    //--------------------------------------------------------------

    static String[] field2Enum = new String[]{
            FIELD2_EQUAL,
            FIELD2_NOEQUAL,
            FIELD2_CONTAINS,
            FIELD2_NOTCONTAINS,
    };

    // *** ДЕЙСТВИЕ --------------------------------------------------------------
    public static final String CLIKER_MOVE = "move";
    public static final String CLIKER_MOVEL = "movel"; // Пометить меткой
    public static final String CLIKER_FORWARD = "forward";
    public static final String CLIKER_FORWARD_WITH_STORE = "forwardwithstore";
    public static final String CLIKER_REPLY = "reply";
    public static final String CLIKER_NOTIFY = "notify";
    public static final String CLIKER_DELETE = "delete";
    //--------------------------------------------------------------

    public static List<String> actionsWithNotifyEnum = Arrays.asList(
            CLIKER_FORWARD,
            CLIKER_NOTIFY,
            CLIKER_FORWARD_WITH_STORE
    );

    // *** Порядок -------------------------------------------------
    public static final String ORDER_FIRST = "0";
    public static final String ORDER_LAST = "1";
    //--------------------------------------------------------------

    static String[] oderEnum = new String[]{ORDER_FIRST, ORDER_LAST};

    // *** Аттачи -------------------------------------------------
    public static final String ATT_ALL = ""; //ко всем письмам
    public static final String ATT_WITH = "1"; // к письмам с аттачем
    public static final String ATT_WO = "2"; // к письмам без аттачей
    //--------------------------------------------------------------

    static String[] attachEnum = new String[]{ATT_ALL, ATT_WITH, ATT_WO};

    // *** Взаимодействие с другими правилами -------------------------------------------------
    public static final String STOP_NO = "0"; //применять последующие правила
    public static final String STOP_YES = "1";//не применять
    //--------------------------------------------------------------

    static String[] stopEnum = new String[]{STOP_YES, STOP_NO};

    // *** язык письма-подтверждения -------------------------------------------------
    public static final String LANG_RU = "ru";
    public static final String LANG_TR = "tr";
    public static final String LANG_EN = "en";
    //--------------------------------------------------------------

    static String[] langEnum = new String[]{LANG_RU, LANG_TR};

    // *** домен для ссылки письма-подтверждения -------------------------------------------------
    public static final String CONFIRM_DOMAIN_YANDEX_RU = "mail.yandex.ru";
    public static final String CONFIRM_DOMAIN_YANDEX_COM = "mail.yandex.com";
    public static final String CONFIRM_DOMAIN_YANDEX_COM_TR = "mail.yandex.com.tr";
    //--------------------------------------------------------------

    static String[] confirmDomainEnum = new String[]{CONFIRM_DOMAIN_YANDEX_COM, CONFIRM_DOMAIN_YANDEX_COM_TR,
            CONFIRM_DOMAIN_YANDEX_RU};

    // *** домен для заголовка From письма-подтверждения -------------------------------------------------
    public static final String AUTH_DOMAIN_YANDEX_RU = "yandex.ru";
    public static final String AUTH_DOMAIN_YANDEX_COM = "yandex.com";
    public static final String AUTH_DOMAIN_YANDEX_COM_TR = "yandex.com.tr";
    public static final String AUTH_DOMAIN_YANDEX_BY = "yandex.by";
    public static final String AUTH_DOMAIN_YANDEX_UA = "yandex.ua";
    //--------------------------------------------------------------

    static String[] authDomainEnum = new String[]{AUTH_DOMAIN_YANDEX_BY, AUTH_DOMAIN_YANDEX_COM,
            AUTH_DOMAIN_YANDEX_COM_TR, AUTH_DOMAIN_YANDEX_RU, AUTH_DOMAIN_YANDEX_UA};

    public static final String NO_CONFIRM = "1";

    public static final String BLACK_LIST = "blacklist";
    public static final String WHITE_LIST = "whitelist";

    public enum FiltersParams {
        NAME("name"),// имя правила
        LETTER("letter"),//:all - ко всем письмам,
        // nospam - кроме спама, clearspam - только к спаму
        ATTACHMENT("attachment"), //: пустой - ко всем письмам, 1 - с аттачами, 2 - без аттачей
        LOGIC("logic"), //: 0 - объединение условий по ИЛИ, 1 - по И
        FIELD1("field1"),//: from/to/cc/subject/body/filename/tocc или имя заголовка письма
        FIELD2("field2"),//: 1 - совпадает, 2 - не совпадает, 3 - содержит, 4 - не содержит
        FIELD3("field3"),//: паттерн
        CLICKER("clicker"),//: тип фильтра
        MOVE_LABEL("move_label"),// - указатель ID метки
        MOVE_FOLDER("move_folder");// - указыватель ID папки

        private String name;

        private FiltersParams(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }

        @Override
        public String toString() {
            return name;
        }
    }
}
