/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ru.yandex.autotests.innerpochta.yfurita.util;

import com.jayway.restassured.path.xml.element.Node;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Response;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import ru.yandex.autotests.innerpochta.tests.unstable.SendMessageProvider;
import ru.yandex.autotests.innerpochta.tests.unstable.User;
import ru.yandex.autotests.innerpochta.wmi.adapter.WmiAdapterUser;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MessageObj;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import javax.mail.Message;
import javax.mail.MessagingException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import com.jayway.restassured.path.json.JsonPath;

import static com.jayway.restassured.RestAssured.expect;
import static java.lang.String.format;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.junit.Assert.fail;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.yfurita.util.FilterSettings.BLACK_LIST;
import static ru.yandex.autotests.innerpochta.yfurita.util.FilterSettings.WHITE_LIST;
import static ru.yandex.autotests.innerpochta.yfurita.util.FuritaConsts.PG_FOLDER_DEFAULT;
import static ru.yandex.autotests.innerpochta.yfurita.util.YfuritaProperties.yfuritaProps;

/**
 * @author stassiak
 */
public class FilterUser extends WmiAdapterUser {
    public static final String USER_TICKET_HEADER = "x-ya-user-ticket";

    private static YfuritaProperties props = new YfuritaProperties();
    private String userInfo;
    private Logger log = LogManager.getLogger(FilterUser.class);

    private List<String> filters;
    private HttpClientManagerRule auth;
    boolean isCorpServer;

    private HashMap<String, String> getMapWithCommonParams() {
        HashMap<String, String> params = new HashMap<>();
        params.put("user", getSuid());
        params.put("db", getMdb());
        params.put("uid", getUid());
        return params;
    }

    public FilterUser(User user) throws Exception {
        super(user);
        userInfo = user.getLogin() + "/" + user.getPassword();
        isCorpServer = props.isCorp;
        auth = super.getAuth();
        filters = getAllFilters();
    }

    public String getUserTicket() throws UnknownHostException {
        return auth.account().userTicket();
    }

    public void refreshFiltersListInfo() throws Exception {
        filters = getAllFilters();
    }

    public boolean switchOffFilters() {
        try {
            for (String fid : filters) {
                disableFilter(fid);
            }
            return true;
        } catch (Exception ex) {
            log.info("Could not switch off filters!: " + ex.getMessage());
            return false;
        }
    }

    public boolean switchOnFilters() {
        try {
            for (String fid : filters) {
                enableFilter(fid);
            }
            return true;
        } catch (Exception ex) {
            log.info("Could not switch off filters!: " + ex.getMessage());
            return false;
        }
    }

    public void sendMessageWithFilterOff(Message m) throws IOException, MessagingException, InterruptedException {
        sendMessageWithFilterOff(new Message[]{m});
    }

    public void sendMessageWithFilterOff(Message[] msgs) throws InterruptedException, MessagingException, IOException {
        switchOffFilters();
        SendMessageProvider.send(msgs, props.getMxServer(), props.getNwsmtpPort());
        for (Message m : msgs) {
            inFolder(PG_FOLDER_DEFAULT).shouldSeeLetterWithSubject(m.getSubject(), 60);
        }
        switchOnFilters();
    }


    public String getFidFromMsg(Message msg) throws Exception {
        String[] filterIds = isCorpServer ? msg.getHeader("X-Yandex-Corp-Autotest-Filter-Id") :
                msg.getHeader("X-Yandex-Autotest-Filter-Id");
        for (String fid : filterIds) {
            log.debug("Looking for filter: " + fid);
            if (filters.contains(fid.trim())) {
                return fid;
            }
        }
        fail("Filter for " + userInfo + " was not found in message!");

        return "";
    }

    public void applyFilter(String filterId, String format) throws Exception {
        String userTicket = getUserTicket();
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);

        expect().statusCode(200).and().body("session", notNullValue())
                    .given().parameters(params)
                    .header(new Header(USER_TICKET_HEADER, userTicket))
                    .get(yfuritaProps().getYfuritaUrl() + "/api/apply.json");
    }

    public void applyFilterWithTvmTicket(String filterId, String format, String userTicket) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);

        expect().statusCode(200).and().body("session", notNullValue())
                    .given().parameters(params)
                    .header(new Header(USER_TICKET_HEADER, userTicket))
                    .get(yfuritaProps().getYfuritaUrl() + "/api/apply.json");
    }

    public void applyFilter(String filterId) throws Exception {
        applyFilter(filterId, YFuritaUtils.JSON);
    }

    public Response previewFilter(String filterId, String format) throws Exception {
        String userTicket = getUserTicket();
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);

        return expect().
                statusCode(200).log().all()
                .given().parameters(params)
                .header(new Header(USER_TICKET_HEADER, userTicket))
                .get(yfuritaProps().getYfuritaUrl() + "/api/preview.json");
    }

    public Response previewFilterWithTvmTicket(String filterId, String format, String userTicket) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);

        return expect().
                statusCode(200)
                .given().parameters(params)
                .header(new Header(USER_TICKET_HEADER, userTicket))
                .get(yfuritaProps().getYfuritaUrl() + "/api/preview.json");
    }

    public JsonPath previewFilter(String filterId) throws Exception {
        return previewFilter(filterId, YFuritaUtils.JSON).jsonPath();
    }

    public Response previewFilter(HashMap<String, String> params, String format) throws Exception {
        String userTicket = getUserTicket();
        params.put("user", getSuid());
        params.put("uid", getUid());
        params.put("db", getMdb());

        return expect().statusCode(200)
                .given().parameters(params)
                .header(new Header(USER_TICKET_HEADER, userTicket))
                .get(yfuritaProps().getYfuritaUrl() + "/api/preview.json");
    }

    public Response previewFilter(NameValuePair[] parameters, String format) throws Exception {
        HashMap<String, String> params = new HashMap<>();
        for (NameValuePair param : parameters) {
            params.put(param.getName(), param.getValue());
        }
        return previewFilter(params, format);
    }

    public String previewFilter(NameValuePair[] params) throws Exception {
        return previewFilter(params, YFuritaUtils.JSON).asString();
    }

    public JsonPath previewFilter(HashMap<String, String> params) throws Exception {
        return previewFilter(params, YFuritaUtils.JSON).jsonPath();
    }

    public Response previewFilter(String filterId, int length, String format) throws Exception {
        String userTicket = getUserTicket();
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);
        params.put("length", Integer.toString(length));

        return expect().statusCode(200)
                .given().parameters(params)
                .header(new Header(USER_TICKET_HEADER, userTicket))
                .get(yfuritaProps().getYfuritaUrl() + "/api/preview.json");

    }

    public String previewFilter(String filterId, int length) throws Exception {
        return previewFilter(filterId, length, YFuritaUtils.JSON).asString();
    }

    public Response previewFilter(String filterId, int length, int offset, String format) throws Exception {
        String userTicket = getUserTicket();
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);
        params.put("length", Integer.toString(length));
        params.put("offset", Integer.toString(offset));

        return expect().statusCode(200)
                .given().parameters(params)
                .header(new Header(USER_TICKET_HEADER, userTicket))
                .get(yfuritaProps().getYfuritaUrl() + "/api/preview.json");
    }

    public String previewFilter(String filterId, int length, int offset) throws Exception {
        return previewFilter(filterId, length, offset, YFuritaUtils.JSON).asString();
    }

    public List<String> getAllFilters() throws Exception {
        return getAllFilters(YFuritaUtils.JSON);
    }

    public List<String> getAllFilters(String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("detailed", "0");

        return expect().statusCode(200).and().body("session", notNullValue())
                    .given().parameters(params)
                    .get(yfuritaProps().getYfuritaUrl() + "/api/list.json")
                    .jsonPath().getList("rules.id");
    }

    public String createFilter(HashMap<String, String> params, String format) throws Exception {
        params.put("user", getSuid());
        params.put("uid", getUid());
        params.put("db", getMdb());

        return expect().statusCode(200).and().body("session", notNullValue())
                    .given().parameters(params)
                    .get(yfuritaProps().getYfuritaUrl() + "/api/edit.json")
                    .jsonPath().getString("id").trim();
    }

    public String createFilter(HashMap<String, String> params) throws Exception {
        return createFilter(params, YFuritaUtils.JSON);
    }

    public String editFilter(HashMap<String, String> params, String filterId, String format) throws Exception {
        params.put("user", getSuid());
        params.put("uid", getUid());
        params.put("id", filterId);
        params.put("db", getMdb());

        return expect().statusCode(200).and().body("session", notNullValue())
                    .given().parameters(params)
                    .get(yfuritaProps().getYfuritaUrl() + "/api/edit.json").jsonPath()
                    .getString("id").trim();
    }

    public void removeFilter(String filterId, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/remove." + format);
    }

    public void removeFilter(String filterId) throws Exception {
        removeFilter(filterId, YFuritaUtils.JSON);
    }

    public void removeFilters(List<String> filterIds, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params).and().parameter("id", filterIds)
                .get(yfuritaProps().getYfuritaUrl() + "/api/remove." + format);
    }

    public void removeFilters(List<String> filterIds) throws Exception {
        removeFilters(filterIds, YFuritaUtils.JSON);
    }

    public Response listFilters(boolean isDetailed, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("detailed", isDetailed ? "1" : "0");

        return expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/list." + format);
    }

    public Response listFilters(boolean isDetailed) throws Exception {
        return listFilters(isDetailed, YFuritaUtils.JSON);
    }

    public Response listFilter(String filterId, boolean isDetailed, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);

        if (isDetailed) {
            params.put("detailed", "1");
        }

        return expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/list." + format);
    }

    public Response listFilter(String filterId, boolean isDetailed) throws Exception {
        return listFilter(filterId, isDetailed, YFuritaUtils.JSON);
    }

    public HashMap getFilter(String filterId, boolean isDetailed) throws Exception {
        List filters = listFilter(filterId, isDetailed).jsonPath().getList("rules");
        assert filters.size() == 1;
        return (HashMap)filters.get(0);
    }

    public void changeOder(List<String> filtersList, String format) throws Exception {
        String list = "";
        for (String filterId : filtersList) {
            list = list.concat(filterId + ",");
        }

        HashMap<String, String> params = getMapWithCommonParams();
        params.put("list", list.substring(0, list.length() - 1));

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/order." + format);
    }

    public void changeOder(List<String> filtersList) throws Exception {
        changeOder(filtersList, YFuritaUtils.JSON);
    }

    public void enableFilter(String filterId, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);
        params.put("enabled", "1");

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/enable." + format);
    }

    public void enableFilter(String filterId) throws Exception {
        enableFilter(filterId, YFuritaUtils.JSON);
    }

    public void disableFilter(String filterId, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("id", filterId);
        params.put("enabled", "0");

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/enable." + format);
    }

    public void disableFilter(String filterId) throws Exception {
        disableFilter(filterId, YFuritaUtils.JSON);
    }

    public void addToBlacklist(String email, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("email", email);

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params).get(yfuritaProps().getYfuritaUrl() + "/api/blacklist_add." + format);
    }

    public void addToBlacklist(String email) throws Exception {
        addToBlacklist(email, YFuritaUtils.JSON);
    }

    public void removeFromBlacklist(String email, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("email", email);

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/blacklist_remove." + format);
    }

    public List<String> getBlacklist(String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        List<String> emails;
        emails = expect().statusCode(200).and().body("session", notNullValue())
                    .given().parameters(params)
                    .get(yfuritaProps().getYfuritaUrl() + "/api/blacklist.json")
                    .jsonPath().getList("addresses");
        List<String> normalizedEmails = new LinkedList<>();
        for (String email : emails) {
            normalizedEmails.add(email.trim());
        }

        return normalizedEmails;
    }

    public List<String> getBlacklist() throws Exception {
        return getBlacklist(YFuritaUtils.JSON);
    }

    public void clearBlacklist(String format) throws Exception {
        for (String email : getBlacklist()) {
            removeFromBlacklist(email, format);
        }
    }

    public void clearBlacklist() throws Exception {
        clearBlacklist(YFuritaUtils.JSON);
    }

    public void addToWhitelist(String email, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("email", email);

        expect().statusCode(200)
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/whitelist_add." + format);
    }

    public void addToWhitelist(String email) throws Exception {
        addToWhitelist(email, YFuritaUtils.JSON);
    }

    public void removeFromWhitelist(String email, String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("email", email);

        expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/whitelist_remove." + format);
    }

    public void removeFromWhitelist(String email) throws Exception {
        removeFromWhitelist(email, YFuritaUtils.JSON);
    }

    public List<String> getWhitelist(String format) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();

        Response resp = expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/whitelist." + format);
        List<String> emails;
        emails = resp.jsonPath().get("addresses");
        List<String> normalizedEmails = new LinkedList<>();
        for (String email : emails) {
            normalizedEmails.add(email.trim());
        }

        return normalizedEmails;
    }

    public List<String> getWhitelist() throws Exception {
        return getWhitelist(YFuritaUtils.JSON);
    }

    public void clearWhitelist() throws Exception {
        for (String email : getWhitelist()) {
            removeFromWhitelist(email);
        }
    }

    public HashMap<String, List<String>> getBlackAndWhitelist() throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();

        Response resp = expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/blackwhitelist");

        HashMap<String, List<String>> result = new HashMap<>();
        result.put(BLACK_LIST, (List<String>) resp.jsonPath().get(BLACK_LIST));
        result.put(WHITE_LIST, (List<String>) resp.jsonPath().get(WHITE_LIST));

        return result;
    }

    public Response getBlackAndWhitelistDetailed() throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("detailed", "1");
        return expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params)
                .get(yfuritaProps().getYfuritaUrl() + "/api/blackwhitelist");
    }

    public Response verify(String e) throws Exception {
        HashMap<String, String> params = new HashMap<>();
        ///  params.put("user", getSuid());
        //  params.put("db", getMdb());
        params.put("e", e);

        return expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params).log().all()
                .get(yfuritaProps().getYfuritaUrl() + "/api/verify.json");
    }

    public Response verify(String e, String from) throws Exception {
        HashMap<String, String> params = getMapWithCommonParams();
        params.put("e", e);
        params.put("from", from);

        return expect().statusCode(200).and().body("session", notNullValue())
                .given().parameters(params).log().all()
                .get(yfuritaProps().getYfuritaUrl() + "/api/verify.json");
    }

    public void removeAllFilters() throws Exception {
        for (String f : getAllFilters()) {
            removeFilter(f);
        }
    }

    public void disableAllFilters() throws Exception {
        for (String f : getAllFilters()) {
            disableFilter(f);
        }
    }

    public String getMsgContentAsString(String mid) throws IOException {
        return api(ru.yandex.autotests.innerpochta.wmi.core.oper.Message.class)
                .params(MessageObj.getMsgWithContentFlag(mid)).post().via(auth.authHC()).getContentTag();
    }


    public void unsubscribeCreate(String email, String displayName, String type, String fid) throws Exception {
        String postBody = format("[{\"email\": \"%s\",\"displayName\": \"%s\",\"type\": \"%s\",\"fid\": \"%s\"}]",
                email, displayName, type, fid);
        expect().statusCode(200)
                .given().body(postBody)
                .post(yfuritaProps().getYfuritaUrl() + "/unsubscribe/create?uid=" + this.getUid() + "&db=pg");
    }

        /*
    .../unsybscribe/create?uid=<UID>&db=pg

Вот пример тела запроса:
[
 {
  "email": "hohoho@faboola.com",
  "displayName": "Faboola",
  "type": "77",
  "fid": "13"
 }
]
HTTP-заголовок Content-Type: application/json
     */
}
