package ru.yandex.autotests.innerpochta.yfurita.util;

import org.apache.commons.httpclient.NameValuePair;
import ru.yandex.autotests.innerpochta.tests.unstable.TestMessage;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import java.io.FileNotFoundException;
import java.util.HashMap;

import static java.lang.String.format;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * User: stassiak
 * Date: 09.07.12
 */
public class RequestsWithConditions {
    public Condition conditionBasic;
    public Condition conditionPlus;
    public HashMap<NameValuePair[], TestMessage> requests;

    public RequestsWithConditions(Condition condition1, Condition condition2)
            throws FileNotFoundException, MessagingException {
        this.conditionBasic = condition1;
        this.conditionPlus = condition2;

        requests = generateRequests();
    }

    private HashMap<NameValuePair[], TestMessage> generateRequests() throws FileNotFoundException, MessagingException {
        HashMap<NameValuePair[], TestMessage> reqs = new HashMap<NameValuePair[], TestMessage>();

        //basic condition test
        Condition condition = new Condition(conditionBasic.logic, conditionBasic.field1, conditionBasic.field2,
                conditionBasic.field1.equals("from") ? randomAlphanumeric(10) + "@ya.ru" : randomAlphanumeric(10));
        NameValuePair[] basicParams = {new NameValuePair("field1", condition.field1),
                new NameValuePair("field2", condition.field2), new NameValuePair("field3", condition.field3)};
        TestMessage m = getMsg(condition);
        reqs.put(basicParams, m);

        if (!condition.field1.equals("from") || !conditionBasic.field1.equals(conditionPlus.field1)) {
            //two conditions test
            NameValuePair[] params = {new NameValuePair("logic", conditionBasic.logic),
                    new NameValuePair("field1", conditionBasic.field1),
                    new NameValuePair("field2", conditionBasic.field2),
                    new NameValuePair("field3", conditionBasic.field3),
                    new NameValuePair("field1", conditionPlus.field1),
                    new NameValuePair("field2", conditionPlus.field2),
                    new NameValuePair("field3", conditionPlus.field3)};

            TestMessage updatedMsg = getMsg(conditionBasic);
            changeMsg(updatedMsg, conditionPlus);
            reqs.put(params, updatedMsg);
        }

        return reqs;
    }

    private void changeMsg(TestMessage message, Condition condition) throws MessagingException, FileNotFoundException {
        if (condition.field1.equals("body")) {
            String newValue = condition.field2.equals("1") ? condition.field3 :
                    message.getSubject() + " " + condition.field3;
            message.setText(newValue);
        } else if (condition.field1.equals("to")) {
            message.removeHeader("To");
            String newValue = condition.field2.equals("1") ? condition.field3 :
                    condition.field3 + "@yandex.com";
            message.setRecipient(newValue);
        } else if (condition.field1.equals("cc")) {
            message.removeHeader("Cc");
            String newValue = condition.field2.equals("1") ? condition.field3 :
                    condition.field3 + ".tr";
            message.setRecipient(Message.RecipientType.CC, new InternetAddress(newValue));
        } else if (condition.field1.equals("subject")) {
            message.removeHeader("Subject");
            String newValue = condition.field2.equals("1") ? condition.field3 :
                    condition.field3 + " " + randomAlphanumeric(5);
            message.setSubject(newValue);
        } else if (condition.field1.equals("test-header")) {
            message.removeHeader("Test-Header");
            String newValue = condition.field2.equals("1") ? condition.field3 :
                    condition.field3 + randomAlphanumeric(5);
            message.setHeader("Test-Header", newValue);
        }

        message.saveChanges();
    }

    private TestMessage getMsg(Condition condition) throws MessagingException, FileNotFoundException {
        TestMessage message = new TestMessage();

        if (!condition.field1.equals("filename")) {
            String from = condition.field1.equals("from") ? condition.field3 : "yantester@yandex.ru";
            message.setFrom(from);
            message.setRecipient("yfurita.pr.c.user@yandex.ru");
            message.setText(format("%s %s %s",
                    randomAlphanumeric(10), randomAlphanumeric(10), randomAlphanumeric(10)));
            message.setSubject(randomAlphanumeric(10));
            changeMsg(message, condition);
            message.saveChanges();
        } else {
            message.setFrom(new InternetAddress("yantester@yandex.ru"));
            message.setRecipient(Message.RecipientType.TO, new InternetAddress("yfurita.pr.c.user@yandex.ru"));
            message.setSubject(randomAlphanumeric(10));

            BodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(format("%s %s %s",
                    randomAlphanumeric(10), randomAlphanumeric(10), randomAlphanumeric(10)));
            Multipart multipart = new MimeMultipart();
            multipart.addBodyPart(messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            DataSource source = new FileDataSource(
                    this.getClass().getClassLoader().getResource("attach/cat1.jpg").getFile());
            messageBodyPart.setDataHandler(new DataHandler(source));
            messageBodyPart.setFileName(condition.field3);
            multipart.addBodyPart(messageBodyPart);
            message.setContent(multipart);
            message.saveChanges();
        }

        return message;
    }
}
