package ru.yandex.autotests.innerpochta.yfurita.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import static java.nio.charset.StandardCharsets.UTF_8;
import static ru.yandex.autotests.innerpochta.yfurita.util.YfuritaProperties.yfuritaProps;

/**
 * Created by alex89 on 17.12.18.
 */
public class SSHCommands {
    private static final Logger LOG = LogManager.getLogger(SSHCommands.class);

    public static Connection getSSHConnection(String testServer, String login, File authKey, String password, Logger log) {
        log.trace("Try to connect by ssh to " + testServer);
        Connection conn = new Connection(testServer);

        try {
            conn.connect();
            log.trace("Authentication with public key...");
            boolean exc = conn.authenticateWithPublicKey(login, authKey, password);
            if (!exc) {
                throw new IOException(String.format("Authentication failed (login: %s)", new Object[]{login}));
            }
        } catch (IOException var7) {
            throw new RuntimeException("Connection to " + testServer + " failed: " + var7.getMessage(), var7);
        }

        log.trace("Connection succeeded");
        return conn;
    }

    public static Connection getSSHConnection(String testServer) {
        try {
            File key = File.createTempFile("key", ".txt");
            FileUtils.writeStringToFile(key, yfuritaProps().getJavaTestsPrivateKey(), UTF_8.toString());
            return getSSHConnection(testServer, "root", key, "", LOG);
        } catch (IOException var5) {
            throw new RuntimeException("Can\'t create log", var5);
        }
    }

    public static String executeCommAndResturnResultAsString(Connection conn, String comm, Logger log)
            throws IOException {
        Session sess = conn.openSession();
        log.info(comm);
        sess.execCommand(comm);
        StreamGobbler stdout = new StreamGobbler(sess.getStdout());
        BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
        String result = "";

        while (true) {
            String line = br.readLine();
            if (line == null) {
                sess.close();
                return result;
            }

            result = result.concat(line + "\n");
        }
    }

    public static void executeComm(Connection conn, String comm, Logger log) throws IOException {
        log.trace(comm);
        Session sess = conn.openSession();
        sess.execCommand(comm);
        sess.close();
    }


}
