package ru.yandex.autotests.innerpochta.yfurita.util;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.yaml.snakeyaml.Yaml;
import ru.yandex.autotests.innerpochta.tests.unstable.User;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Charsets.UTF_8;
import static com.google.common.io.Resources.asCharSource;
import static com.google.common.io.Resources.getResource;
import static ru.yandex.autotests.innerpochta.util.InnerpochtaProjectProperties.innerpochtaProps;
import static ru.yandex.autotests.innerpochta.yfurita.util.YfuritaProperties.yfuritaProps;

/**
 * User: alex89
 * Date: 16.07.2015
 */

public class UserInitializationRule extends TestWatcher {


//    private void getUsersList() throws IOException {
//        Map<String, List<String>> testCasesMap =
//                new Yaml().loadAs(asCharSource(getResource(yfuritaProps().getAccountsFile()), UTF_8).read(), Map.class);
//        for (String comment : testCasesMap.keySet()) {
//            for (String body : testCasesMap.get(comment)) {
//                data.add(new Object[]{body.replace(UID_FOR_CHANGE, getRandomUidForNegativeTest()), comment});
//            }
//        }
//    }


    public UserInitializationRule initUsers(Field[] fields) {
        for (Field field : fields) {

            if (field.isAnnotationPresent(Credentials.class)) {
                try {
                    if (!field.getAnnotation(Credentials.class).login().equals("")) {
                        field.set(null, new User(
                                field.getAnnotation(Credentials.class).login(),
                                field.getAnnotation(Credentials.class).pwd()));
                    } else {
                        field.set(null, new User(
                                yfuritaProps().user(
                                        field.getAnnotation(Credentials.class).loginGroup()).getLogin(),
                                yfuritaProps().user(
                                        field.getAnnotation(Credentials.class).loginGroup()).getPassword()));
                    }

                } catch (IllegalAccessException e) {
                    new RuntimeException("Не проинициализаровали тестового пользователя");
                }
            }


        }
        return this;
    }

    @Override
    protected void starting(Description description) {
        initUsers(description.getTestClass().getFields());
    }
}