package ru.yandex.autotests.innerpochta.yfurita.util;

import com.jayway.restassured.path.json.JsonPath;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import static org.hamcrest.core.IsEqual.equalTo;

/**
 * User: stassiak
 * Date: 09.07.12
 */
public class YFuritaPreviewResponse {
    String okLine;
    List<String> mids = new LinkedList<String>();
    int size = 0;

    public YFuritaPreviewResponse(String resp) {
        String[] lines = resp.split("\n");

        okLine = lines[0];
        size = Integer.parseInt(okLine.split(":")[1].trim());
        mids.addAll(Arrays.asList(lines).subList(1, lines.length));
        Collections.sort(mids);
    }

    public YFuritaPreviewResponse(String[] msgIds) {
        size = msgIds.length;
        Collections.addAll(mids, msgIds);
        Collections.sort(mids);
    }

    public YFuritaPreviewResponse(List<String> mids) {
        size = mids.size();
        this.mids = mids;
        Collections.sort(mids);
    }

    public YFuritaPreviewResponse(JsonPath jsonPath) {
        size = jsonPath.getInt("size");
        mids = jsonPath.getList("messages");
        Collections.sort(mids);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.mids != null ? this.mids.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }

        YFuritaPreviewResponse resp = (YFuritaPreviewResponse) obj;
        if (size != resp.size || !equalTo(mids).matches(resp.mids)) {
            return false;
        }
        return true;
    }

    public String print() {
        String printStr = "OK: " + size + "\n";
        for (String mid : mids) {
            printStr = printStr.concat(mid + "\n");
        }

        return printStr;
    }

    @Override
    public String toString() {
        return print();
    }
}
