package ru.yandex.autotests.innerpochta.yfurita.util;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.MatcherAssert;
import ru.yandex.autotests.innerpochta.tests.unstable.SendMessageProvider;
import ru.yandex.autotests.innerpochta.tests.unstable.TestMessage;
import ru.yandex.autotests.innerpochta.tests.unstable.User;

import javax.mail.Message;
import javax.mail.MessagingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.jayway.restassured.path.json.JsonPath;

import static java.lang.Thread.currentThread;
import static java.util.concurrent.TimeUnit.MINUTES;
import static java.util.concurrent.TimeUnit.SECONDS;
import static org.apache.commons.io.IOUtils.copy;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.eclipse.jetty.http.HttpStatus.OK_200;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertTrue;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.WaitForMatcherDecorator.withWaitFor;
import static ru.yandex.autotests.innerpochta.yfurita.util.FuritaConsts.PG_FOLDER_DEFAULT;
import static ru.yandex.autotests.innerpochta.yfurita.util.YfuritaProperties.yfuritaProps;
import static ru.yandex.autotests.innerpochta.yfurita.util.matchers.MessageIndexedMatcher.messageIndexed;

/**
 * User: amois
 * Date: 18.01.12
 * Time: 17:25
 */
public class YFuritaUtils {
    private static final Logger LOG = LogManager.getLogger(YFuritaUtils.class);
    public static final String XML = "xml";
    public static final String JSON = "json";

    public static Condition[] getTestConditions() {

        return new Condition[]{
                new Condition("0", "from", "1", "yantester@yandex.ru"),
                new Condition("0", "from", "3", "yantester@yandex.ru"),
                new Condition("0", "to", "1", randomAlphanumeric(10)),
                new Condition("0", "to", "3", randomAlphanumeric(10)),
                new Condition("0", "subject", "1", randomAlphanumeric(10)),
                new Condition("0", "subject", "3", randomAlphanumeric(10)),
                new Condition("0", "body", "1", randomAlphanumeric(10)),
                new Condition("0", "body", "3", randomAlphanumeric(10)),
                new Condition("0", "filename", "1", randomAlphanumeric(10) + ".jpg"),
                new Condition("0", "filename", "3", randomAlphanumeric(10) + ".jpg"),
                new Condition("0", "test-header", "1", randomAlphanumeric(10)),
                new Condition("0", "test-header", "3", randomAlphanumeric(10)),
                new Condition("1", "to", "1", randomAlphanumeric(10)),
                new Condition("1", "to", "3", randomAlphanumeric(10)),
                new Condition("1", "cc", "1", randomAlphanumeric(10)),
                new Condition("1", "cc", "3", randomAlphanumeric(10)),
                new Condition("1", "subject", "1", randomAlphanumeric(10)),
                new Condition("1", "subject", "3", randomAlphanumeric(10)),
                new Condition("1", "body", "1", randomAlphanumeric(10)),
                new Condition("1", "body", "3", randomAlphanumeric(10)),
                new Condition("1", "filename", "1", randomAlphanumeric(10) + ".jpg"),
                new Condition("1", "filename", "3", randomAlphanumeric(10) + ".jpg"),
                new Condition("1", "test-header", "1", randomAlphanumeric(10)),
                new Condition("1", "test-header", "3", randomAlphanumeric(10))
        };
    }

    public static Message[] getMsgs(int n, String subjPattern, String to)
            throws MessagingException, FileNotFoundException {
        Message[] msgs = new Message[n];
        for (int i = 0; i < n; i++) {
            TestMessage m = new TestMessage();
            m.setFrom("yantester@yandex.ru");
            m.setRecipient(to);
            m.setSubject(subjPattern + ": " + randomAlphanumeric(15));
            m.setText(randomAlphanumeric(30));
            m.saveChanges();

            msgs[i] = m;
        }
        return msgs;
    }

    public static String getRandomEmail() {
        return randomAlphanumeric(15) + "@" + randomAlphanumeric(5) + "." + randomAlphanumeric(3);
    }

    public static HashMap<String, TestMessage> sendAllTestMsgsFromResourceFolder(String resourceFolderName,
                                                                                 User rcpt)
            throws MessagingException, IOException, InterruptedException {
        File folderWithEmls = new File(currentThread()
                .getContextClassLoader().getResource(resourceFolderName).getFile());
        HashMap<String, TestMessage> fileNameAndTestMsg = new HashMap<String, TestMessage>();
        for (File file : folderWithEmls.listFiles()) {
            TestMessage testMessage = new TestMessage(file);
            testMessage.setRecipient(rcpt.getLogin());
            testMessage.saveChanges();
            SendMessageProvider.send(testMessage,
                    yfuritaProps().getMxServer(), yfuritaProps().getNwsmtpPort());
            fileNameAndTestMsg.put(file.getName(), testMessage);
        }

        return fileNameAndTestMsg;
    }

    public static HashMap<String, String> getMidsTableFromMailBox(FilterUser fUser,
                                                                  HashMap<String, TestMessage> fileNamesAndTestMsgs)
            throws MessagingException, IOException, InterruptedException {
        HashMap<String, String> fileNamesAndMids = new HashMap<String, String>();
        for (String name : fileNamesAndTestMsgs.keySet()) {
            String subject = fileNamesAndTestMsgs.get(name).getSubject();
            fUser.shouldSeeLetterWithSubject(subject);
            String mid = fUser.inFolder(PG_FOLDER_DEFAULT).getMidOfMessageWithSubject(subject);
            fileNamesAndMids.put(name, mid);
            assumeThat(mid, withWaitFor(messageIndexed(fUser), MINUTES.toMillis(10), SECONDS.toMillis(10)));
        }
        LOG.info(fileNamesAndTestMsgs);
        LOG.info(fileNamesAndMids);
        return fileNamesAndMids;
    }

    public static YFuritaPreviewResponse getPreviewResponseEtalon(List<String> expectedTestLettersNames,
                                                                  HashMap<String, String> fileNamesAndMids) {
        String[] expectedMids = new String[expectedTestLettersNames.size()];
        for (int i = 0; i < expectedMids.length; i++) {
            expectedMids[i] = fileNamesAndMids.get(expectedTestLettersNames.get(i));
        }
        return new YFuritaPreviewResponse(expectedMids);
    }


    /*
    *  Замена стандартному методу из-за недоработку РА - он перемешивает параметры=-(
    * */
    public static String createFilterWithHttpClient(String params, Logger log) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String url = yfuritaProps().getYfuritaUrl() + "/api/edit.json" + params;
        log.info("Создаём фильтр:" + url);
        HttpGet httpget = new HttpGet(url);

        HttpResponse response = httpClient.execute(httpget);
        log.info(response);

        MatcherAssert.assertThat("При создании фильтра получили ошибку: " + response,
                response.getStatusLine().getStatusCode(), equalTo(OK_200));
        StringWriter writer = new StringWriter();
        copy(response.getEntity().getContent(), writer);
        String responseContent = writer.toString();
        log.info(responseContent);

        Matcher idFormat = Pattern.compile("\"id\":\"([0-9]+)\"(.*)").matcher(responseContent.trim());
        assertTrue("Не удалось найти в ответе Фуриты " + responseContent, idFormat.find());
        log.info("Создали фильтр:" + responseContent);
        return idFormat.group(1);
    }

    /*
    *  Замена стандартному методу из-за недоработку РА - он перемешивает параметры=-(
    * */
    public static JsonPath previewFilterWithHttpClient(String params, Logger log) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String url = yfuritaProps().getYfuritaUrl() + "/api/preview.json" + params;
        log.info("Делаем превью-запрос:" + url);
        HttpGet httpget = new HttpGet(url);

        HttpResponse response = httpClient.execute(httpget);
        log.info(response);

        MatcherAssert.assertThat("При преквью запросе получили ошибку: " + response,
                response.getStatusLine().getStatusCode(), equalTo(OK_200));
        StringWriter writer = new StringWriter();
        copy(response.getEntity().getContent(), writer);
        String responseContent = writer.toString();
        log.info(responseContent);


//        Matcher idFormat = Pattern.compile("\"id\":\"([0-9]+)\"(.*)").matcher(responseContent.trim());
//        assertTrue("Не удалось найти в ответе Фуриты " + responseContent, idFormat.find());
//        log.info("Создали фильтр:" + responseContent);
        return new JsonPath(responseContent);
    }

    public static void prepareTestFoldersAndLabels(FilterUser fUser) throws IOException {
//         fUser.createFolder("test1");
//         fUser.createLabel("test1");
//         fUser.createLabel("test2");
//         fUser.createLabel("11,22");
    }
}
