package ru.yandex.autotests.innerpochta.yfurita.util;

import ru.qatools.properties.Property;
import ru.qatools.properties.PropertyLoader;
import ru.qatools.properties.Resource;
import ru.qatools.properties.Use;
import ru.qatools.properties.providers.SysPropPathReplacerProvider;
import ru.yandex.autotests.innerpochta.tests.unstable.User;
import ru.yandex.qatools.secrets.Secret;
import ru.yandex.qatools.secrets.SecretsLoader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import static com.google.common.collect.Lists.newArrayList;
import static org.hamcrest.text.IsEmptyString.isEmptyOrNullString;
import static ru.yandex.qatools.properties.utils.PropertiesUtils.readProperties;

/**
 * User: stassiak
 * Date: 20.09.12
 */
@Resource.Classpath("yfurita.${system.testing.furita.scope}.properties")
public class YfuritaProperties {
    static final String PROPERTY_FILE_KEY = "properties.file";

    private static YfuritaProperties instance;

    public static YfuritaProperties yfuritaProps() {
        if (instance == null) {
            instance = new YfuritaProperties();
        }
        return instance;
    }

    public YfuritaProperties() {
        PropertyLoader.newInstance().withPropertyProvider(new SysPropPathReplacerProvider())
                .populate(this);
        SecretsLoader.populate(this);

    }

    @Secret("sec-01cycce5e6j67n3tjs89v5bmsg") // https://yav.yandex-team.ru/secret/sec-01cycce5e6j67n3tjs89v5bmsg
    private String javaTestsPrivateKey;

    @Property("java.tests.user.name")
    private String javaTestsUserName = "robot-mx-tests";

    public String getJavaTestsPrivateKey() {
        return javaTestsPrivateKey;
    }

    public String getJavaTestsUserName() {
        return javaTestsUserName;
    }

    @Property("yfurita.host")
    private String host = "superava-qa.mail.yandex.net";

    @Property("yfurita.port")
    private int port = 10010;

    @Property("msearch.url")
    private String msearchUrl = "http://new-msearch-proxy.mail.yandex.net:8051";

    @Property("msearch.query.host")
    private String msearchQueryHost = "furita-qa2.cmail.yandex.net";

    @Property("wmi.api.url")
    protected String wmiApiUrl = "http://mail.yandex.ru/api/";

    @Property("mx.server")
    protected String mxServer = "mxcorp1.mail.yandex.net";

    @Property("nwsmtp.port")
    protected int nwsmtpPort = 25;

    @Property("is.corp")
    protected boolean isCorp = false;

    @Property("yfurita.testuser.login")
    protected String yfuritaTestuserLogin = "";

    @Property("yfurita.testuser.password")
    protected String yfuritaTestuserPassword = "";

    @Property("is.pg")
    protected boolean isPg = false;

    @Property("accounts.file")
    protected String accountsFile = "accounts/noncorp.yaml";

    public boolean isPg() {
        return isPg;
    }

    public boolean isCorp() {
        return isCorp;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public String getMsearchUrl() {
        return msearchUrl;
    }

    public String getMsearchQueryHost() {
        return msearchQueryHost;
    }

    public String getWMIApiUrl() {
        return wmiApiUrl;
    }

    public String getMxServer() {
        return mxServer;
    }

    public int getNwsmtpPort() {
        return nwsmtpPort;
    }

    public String getAccountsFile() {
        return accountsFile;
    }

    @Use(YamlConverter.class)
    @Property("mailboxes.yaml.file")
    private Map<String, List<Map<String, String>>> users = new HashMap<String, List<Map<String, String>>>() {{
        put(Credentials.DEFAULT_LOGIN_GROUP, newArrayList(new HashMap<String, String>() {{
            put("defaultuser", "testqa");
        }}));
    }};

    public List<User> users(String loginGroup) {
        if (users.containsKey(loginGroup)) {
            List<User> accountsList = newArrayList();
            users.get(loginGroup).forEach(map -> accountsList.add(new User(map.get("login"),
                    map.get("pwd"))));
            return accountsList;

        } else {
            throw new IllegalArgumentException("В конфиге нет аккаунта для группы: " + loginGroup);
        }
    }

    public Map<String, User> users() {
        Map<String, User> result = new HashMap<>();
        for (String key : users.keySet()) {
            result.put(key, user(key));
        }
        return result;
    }

    public User user(String loginGroup) {
        return users(loginGroup).get(0);
    }


    public String getYfuritaTestuserLogin() {
        return yfuritaTestuserLogin.contains("@") ? yfuritaTestuserLogin : yfuritaTestuserLogin + "@ya.ru";
    }

    public String getYfuritaTestuserPassword() {
        return yfuritaTestuserPassword;
    }

    public boolean isBaseTesting() {
        return !isEmptyOrNullString().matches(yfuritaTestuserLogin);
    }

    public String getYfuritaUrl() {
        return "http://" + host + ":" + port;
    }


    private static Properties loadProperties() {
        Properties result = new Properties();
        String filePath = System.getProperty(PROPERTY_FILE_KEY);
        if (filePath != null) {
            result.putAll(readProperties(Thread.currentThread().getContextClassLoader().getSystemResourceAsStream(filePath)));
        }
        return result;
    }

    /**
     * Нужно для тестирования баз.
     * Если задан пользователь yfuritaTestuserLogin, то выбираем его.
     *
     * @param bigMailUser  - пользователь большой почты;
     * @param corpMailUser - пользователь корпоративной почты;
     * @return пользователь, на котором будем тестировать в зависимости от условий.
     */

    public static User chooseUser(User bigMailUser, User corpMailUser) {
        if (yfuritaProps().isBaseTesting()) {
            return new User(yfuritaProps().getYfuritaTestuserLogin(), yfuritaProps().getYfuritaTestuserPassword());
        }
        return yfuritaProps().isCorp() ? corpMailUser : bigMailUser;
    }

    /**
     * Нужно для тестирования баз.
     * Если задан пользователь yfuritaTestuserLogin, то выбираем его.
     *
     * @param bigMailUser   - пользователь большой почты;
     * @param corpMailUser  - пользователь корпоративной почты;
     * @param pgBigMailUser - пользователь большой почты  постгресе;
     * @return пользователь, на котором будем тестировать в зависимости от условий.
     */

    public static User chooseUser(User bigMailUser, User corpMailUser, User pgBigMailUser) {
        if (yfuritaProps().isBaseTesting()) {
            return new User(yfuritaProps().getYfuritaTestuserLogin(), yfuritaProps().getYfuritaTestuserPassword());
        }
        if (yfuritaProps().isCorp()) {
            return corpMailUser;
        }
        if (yfuritaProps().isPg()) {
            return pgBigMailUser;
        }
        return bigMailUser;
    }
}
