package ru.yandex.autotests.innerpochta.yfurita.util.matchers;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.path.xml.XmlPath;
import com.jayway.restassured.path.xml.element.Node;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.yfurita.util.FilterSettings;

import java.util.HashMap;
import java.util.List;

import static org.hamcrest.CoreMatchers.isA;

/**
 * User: stassiak
 * Date: 13.02.13
 */
public class FilterSettingsListMatcher<T> extends FeatureMatcher<T, HashMap<String, HashMap<String, String>>> {

    public FilterSettingsListMatcher(Matcher<? super HashMap<String, HashMap<String, String>>> subMatcher) {
        super(subMatcher, "имеет следующие фильтры", "список фильтров");
    }

    @Override
    protected HashMap<String, HashMap<String, String>> featureValueOf(T path) {
        HashMap<String, HashMap<String, String>> filterSettingsList = new HashMap<String, HashMap<String, String>>();
        if (isA(XmlPath.class).matches(path)) {
            XmlPath rulesXml = (XmlPath) path;
            List<String> filterIds = rulesXml.getList("body.rule.@id");

            for (String filterId : filterIds) {
                Node filter = rulesXml.getNode("body.rule.findAll { it.@id == '" + filterId + "' }[0]");
                filterSettingsList.put(filterId, FilterSettings.getSettings(filter));
            }
            return filterSettingsList;
        }
        if (isA(JsonPath.class).matches(path)) {
            JsonPath jsonPath = (JsonPath) path;
            for (int i = 0; i < jsonPath.getList("rules").size(); i++) {
                filterSettingsList.put(jsonPath.getString("rules[" + i + "].id"),
                        FilterSettings.getSettings(jsonPath, i));
            }
            return filterSettingsList;
        }
        throw new ClassCastException("Matcher can be used only with com.jayway.restassured.path.json.JsonPath or " +
                "com.jayway.restassured.path.xml.XmlPath");
    }

    @Factory
    public static FilterSettingsListMatcher hasSettingsList(Matcher<? super HashMap<String, HashMap<String, String>>>
                                                                    subMatcher) {
        return new FilterSettingsListMatcher(subMatcher);
    }
}
