package ru.yandex.autotests.innerpochta.yfurita.util.matchers;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.path.xml.XmlPath;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.yfurita.util.FilterSettings;

import java.util.HashMap;

import static org.hamcrest.CoreMatchers.isA;

/**
 * User: stassiak
 * Date: 12.02.13
 */
public class FilterSettingsMatcher<T> extends FeatureMatcher<T, HashMap<String, String>> {

    public FilterSettingsMatcher(Matcher<? super HashMap<String, String>> subMatcher) {
        super(subMatcher, "имеет следующие настройки", "настройки фильтра");
    }

    @Override
    protected HashMap<String, String> featureValueOf(T path) {
        if (isA(XmlPath.class).matches(path)) {
            return FilterSettings.getSettings((XmlPath) path);
        }
        if (isA(JsonPath.class).matches(path)) {
            return FilterSettings.getSettings((JsonPath) path);
        }
        throw new ClassCastException("Matcher can be used only with com.jayway.restassured.path.json.JsonPath or " +
                "com.jayway.restassured.path.xml.XmlPath");
    }

    @Factory
    public static FilterSettingsMatcher hasSettings(Matcher<? super HashMap<String, String>> subMatcher) {
        return new FilterSettingsMatcher(subMatcher);
    }
}
