package ru.yandex.autotests.innerpochta.yfurita.util.matchers;

import com.jayway.restassured.path.json.JsonPath;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import static java.lang.String.format;
import static org.hamcrest.CoreMatchers.isA;

/**
 * User: stassiak
 * Date: 18.02.13
 */
public class FiltersOrderMatcher<T> extends FeatureMatcher<T, ArrayList<String>> {

    public FiltersOrderMatcher(Matcher<? super ArrayList<String>> subMatcher) {
        super(subMatcher, "имеет следующий порядок фильтров по убыванию приоритета",
                "порядок фильтров по убыванию приоритета");
    }

    @Override
    protected ArrayList<String> featureValueOf(T path) {
        if (isA(JsonPath.class).matches(path)) {
            return getFiltersOrder((JsonPath) path);
        }
        throw new ClassCastException("Matcher can be used only with com.jayway.restassured.path.json.JsonPath");
    }

    private ArrayList<String> getFiltersOrder(JsonPath rules) {
        ArrayList<String> filters = new ArrayList<String>();

        List<Integer> priorities = rules.get("rules.priority");
        Collections.sort(priorities);
        for (Integer priority : priorities) {
            filters.add(rules.get(format("rules.find { it.priority == %d }.id", priority)));
        }

        String list = "";
        for (String filterId : filters) {
            list = list.concat(filterId + ",");
        }
        System.out.println("ACTUAL: " + list.substring(0, list.length() - 2));

        return filters;
    }

    @Factory
    public static FiltersOrderMatcher hasOrder(Matcher<? super ArrayList<String>> subMatcher) {
        return new FiltersOrderMatcher(subMatcher);
    }

}
