package ru.yandex.autotests.innerpochta.yfurita.util.matchers;

import ch.ethz.ssh2.Connection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import ru.yandex.autotests.innerpochta.yfurita.util.FilterUser;

import java.io.IOException;

import static java.lang.String.format;
import static org.junit.Assert.fail;
import static ru.yandex.autotests.innerpochta.yfurita.util.SSHCommands.executeCommAndResturnResultAsString;
import static ru.yandex.autotests.innerpochta.yfurita.util.SSHCommands.getSSHConnection;
import static ru.yandex.autotests.innerpochta.yfurita.util.YfuritaProperties.yfuritaProps;

/**
 * User: stassiak
 * Date: 11.07.13
 */
public class MessageIndexedMatcher extends BaseMatcher<String> {
    private static final String INDEXED_REQUEST =
            "curl '"+yfuritaProps().getMsearchUrl()+"/api/async/mail/" +
                    "search?request=%s&mdb=%s&uid=%s'";
    private Logger log = LogManager.getLogger(MessageIndexedMatcher.class);
    private String mid;
    private String db;
    private String uid;

    public MessageIndexedMatcher(String db, String uid) {
        this.db = db;
        this.uid = uid;
    }

    @Override
    public boolean matches(Object o) {
        mid = (String) o;
        try {
            Connection conn = getSSHConnection(yfuritaProps().getMsearchQueryHost());
            String result = executeCommAndResturnResultAsString(conn, format(INDEXED_REQUEST, mid, db, uid), log);
            conn.close();
            return result.contains(format("\"mid\":\"%s\"", mid));
        } catch (IOException e) {
            fail("Could not check if message was indexed: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        description.appendText("Message " + item + " is not indexed");
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Message " + mid + " is indexed");
    }

    @Factory
    public static MessageIndexedMatcher messageIndexed(FilterUser fUser) {
        return new MessageIndexedMatcher(fUser.getMdb(), fUser.getUid());
    }
}
