package ru.yandex.calendar.genversion;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;

import ru.yandex.library.svnversion.VcsVersion;

public class GenVersion {
    private static final VcsVersion VCS = new VcsVersion(GenVersion.class);
    public static void main(String[] args) {
        String projectName = args[0];
        String outputDir = args[1];
        String outputFile = args[2];
        new File(outputDir).mkdirs();

        String outputFileName = Paths.get(outputDir, outputFile).toString();
        try {
            PrintWriter writer = new PrintWriter(outputFileName, "UTF-8");
            writer.println("project.svn.rev=" + VCS.getProgramSvnRevision());
            writer.println("project.svn.url=" + VCS.getArcadiaSourceUrl().trim() + "/" + projectName);
            writer.println("project.version=" + VCS.getProgramSvnRevision());
            writer.println("build.date=" + VCS.getProgramBuildDate());
            writer.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
