### Описание

Данное расширение **junit-5** позволяет запустить сконфигурированный цербер в тестовом окружении. Расширение основывается на **mail/java/junit_extensions/program_runner**.

Для получения конфигурации цербера необходимо в вашем **ProgramRegistry** для приложения с **id**=```Cerberus.NAME``` возвращать результат вызова ```Cerberus.options()```. Пример:

```java
public class MyProgramRegistry implements ProgramRegistry {
    @Override
    public Optional<ProgramOptions> findProgramOptions(String id) {
        if (id.equals(Cerberus.NAME)) {
            int port = 100500; // Порт, на котором будет запущен цербер
            List<String> dbHosts = ...; // Список хостов БД, которую будет использовать цербер. Нужно преднастроить, например, при помощи pglocal.
            String dbName = "cerberusdb"; // имя БД
            String login = "cerberus"; // юзер БД
            String password = "12345"; // пароль юзера БД
            var options = Cerberus.options(port, dbHosts, dbName, login, password);
            return Optional.of(options);
        } else {
            return Optional.empty();
        }
    }
}
```

Далее в тесте просто поключаем реестр и подключаем цербер при помощи аннотации ```@RunCerberus```.
```java
@RunCerberus
@RegisterProgramsRegistry(MyProgramRegistry.class)
class MyTest {
}
```

#### Arcadia specific
Для корректной работы тестов при запуске через ```ya make -tt``` необходимо сделать следующее:
* Задать свойство **ea_async_path** в **JVM_ARGS** теста
* В секции **DEPENDS** указать путь к **mail/cerberus/service/uberjar**
* В секции **DATA** указать путь к **arcadia/mail/java/junit_extensions/cerberus_runner/configuration**

```make
INCLUDE(${ARCADIA_ROOT}/mail/micronaut/dependency_versions.inc)

JVM_ARGS(
    -Dea_async_path=${EA_ASYNC_AGENT_PATH} # EA_ASYNC_AGENT_PATH можно получить из dependency_versions.inc
)

DEPENDS(
    mail/cerberus/service/uberjar
)

DATA(
    arcadia/mail/java/junit_extensions/cerberus_runner/configuration
)
```
