package ru.yandex.mail.junit_extensions.cerberus_runner;

import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import one.util.streamex.StreamEx;
import ru.yandex.mail.arcadia_test_support.TestPaths;
import ru.yandex.mail.junit_extensions.program_runner.ProgramOptions.JavaProgramOptions;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

@Slf4j
@UtilityClass
public class Cerberus {
    private static final Duration START_TIMEOUT = Duration.ofMinutes(1);
    private static final String MAIN_CLASS = "ru.yandex.mail.cerberus.Main";
    private static final Path JAR_PATH = TestPaths.getBuildPath("mail", "cerberus", "service", "uberjar", "cerberus.jar");
    private static final Path RESOURCES_PATH = TestPaths.getSourcePath("mail", "java", "junit_extensions",
        "cerberus_runner", "configuration");
    private static final Path CONFIG_PATH = RESOURCES_PATH.resolve("application-test.yml");
    private static final Path LOG4j_CONFIG_PATH = RESOURCES_PATH.resolve("log4j2.yaml");
    private static final String EA_ASYNC_PATH_PROPERTY = "ea_async_path";
    private static final Path EA_ASYNC_PATH = Paths.get(requireNonNull(System.getProperty(EA_ASYNC_PATH_PROPERTY)));
    private static final List<String> JVM_OPTIONS = List.of(
        "-Dfile.encoding=UTF-8",
        "-Djava.net.preferIPv6Addresses=true",
        "-Dmicronaut.env.deduction=false",
        "-Dmicronaut.environments=test",
        "-Dmicronaut.config.files=" + CONFIG_PATH,
        "-Dlog4j.configurationFile=" + LOG4j_CONFIG_PATH,
        "-javaagent:" + EA_ASYNC_PATH
    );

    public static final String NAME = "cerberus";

    public static JavaProgramOptions options(int port, List<String> dbHosts, String dbName, String dbUser, String dbPassword) {
        val jvmOptions = StreamEx.of(JVM_OPTIONS)
            .append("-Dtest.server-port=" + port)
            .append("-Dtest.jdbc.hosts=" + String.join(",", dbHosts))
            .append("-Dtest.jdbc.dbname=" + dbName)
            .append("-Dtest.jdbc.username=" + dbUser)
            .append("-Dtest.jdbc.password=" + dbPassword)
            .toImmutableList();
        return new JavaProgramOptions(JAR_PATH, Optional.empty(), jvmOptions, MAIN_CLASS, new CerberusHealthCheck(port),
            Optional.of(START_TIMEOUT));
    }
}
