package ru.yandex.mail.junit_extensions.cerberus_runner;

import lombok.SneakyThrows;
import lombok.val;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;

class CerberusClient {
    private final int port;
    private final HttpClient client;

    public CerberusClient(int port) {
        this.port = port;
        this.client = HttpClient.newBuilder()
            .version(HttpClient.Version.HTTP_1_1)
            .connectTimeout(Duration.ofSeconds(10))
            .build();
    }

    @SneakyThrows
    public Optional<HttpResponse<Void>> ping() {
        val uri = URI.create("http://localhost:" + port + "/ping");
        val request = HttpRequest.newBuilder()
            .version(HttpClient.Version.HTTP_1_1)
            .timeout(Duration.ofSeconds(5))
            .GET()
            .uri(uri)
            .build();

        try {
            return Optional.of(client.send(request, HttpResponse.BodyHandlers.discarding()));
        } catch (IOException e) {
            return Optional.empty();
        }
    }
}
