package ru.yandex.mail.junit_extensions.cerberus_runner;

import ru.yandex.mail.junit_extensions.program_runner.HealthStatus;
import ru.yandex.mail.junit_extensions.program_runner.ProgramOptions.HealthCheck;

import java.net.http.HttpResponse;

public class CerberusHealthCheck implements HealthCheck {
    private final CerberusClient client;

    public CerberusHealthCheck(int port) {
        this.client = new CerberusClient(port);
    }

    @Override
    public HealthStatus check() {
        return client.ping()
            .map(HttpResponse::statusCode)
            .filter(status -> status == 200)
            .map(status -> HealthStatus.UP)
            .orElse(HealthStatus.DOWN);
    }
}
