JUNIT5()

JDK_VERSION(11)

OWNER(
    imdex
    g:calendar-back
)

IF (SANITIZER_TYPE)
    TAG(ya:not_autocheck)
ENDIF()

JAVAC_FLAGS(
    -Xlint:unchecked
)

SIZE(medium)
NO_LINT()
REQUIREMENTS(network:full)

INCLUDE(${ARCADIA_ROOT}/mail/micronaut/dependency_versions.inc)

JVM_ARGS(
    -Dea_async_path=${EA_ASYNC_AGENT_PATH}
)

PEERDIR(
    mail/java/junit_extensions/cerberus_runner
    mail/java/arcadia_test_support
    mail/java/pglocal/junit_jupiter
    contrib/java/org/assertj/assertj-core
    contrib/java/org/junit/jupiter/junit-jupiter-engine
    contrib/java/org/apache/logging/log4j/log4j-1.2-api
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml
)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/java/junit_extensions/cerberus_runner/src/test/java **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/java/junit_extensions/cerberus_runner/src/test/resources **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/pg/cerberusdb **/*)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
)

DEPENDS(
    mail/cerberus/service/uberjar
)

DATA(
    arcadia/mail/java/junit_extensions/cerberus_runner/configuration
)

END()
