### Описание

Данное расширение **junit-5** позволяет легко запускать любые приложение перед запуском тестов.

В первую очередь необходимо настроить реестр приложений, для этого нужно объявить класс, реализующий интерфейс **ProgramRegistry**, который по запрошенному **id** приложения должен вернуть его конфигурацию. Рассмотрим пример:
```java
public class TestProgramRegistry implements ProgramRegistry {
    @Override
    public Optional<ProgramOptions> findProgramOptions(String id) {
        if (id.equals("my-application-id")) {
            Path jarPath = "mail/my_app/my_app.jar"; // Путь к *.jar файлу приложения
            Path jvmOptionsFilePath = "mail/my_app/jvm_opts"; // Путь к файлу со списком опций JVM, который будет передан вирутальной машине при запуске
            List<String> jvmArgs = ["-Xmx=100500G", "-Xmn=10G"]; // Список аргументов JVM
            String mainClassName = "ru.yandex.mail.Main"; // Имя класса, содержащего метод main
            HealthCheck healthCheck = ...; // Реализация health check'ера для приложения. Если не требуется можно передать ProgramOptions.NO_HEALTH_CHECK
            Duration startTimeout = 100s; // Таймаут на запуск приложения, если не задан, то используется дефолтный.
            var options = new JavaProgramOptions(jarPath, Optional.of(jvmOptionsFilePath), jvmArgs, mainClassName, healthCheck, Optional.of(startTimeout));
            return Optional.of(options);
        } else {
            return Optional.empty();
        }
    }
}
```

Далее в тесте просто поключаем реестр и указываем список приложений, которые необходимо запустить перед запуском тестов.
```java
@RunProgram(name = "my-application-id")
@RegisterProgramsRegistry(TestProgramRegistry.class)
class MyTest {
    @Test
    void testJavaProgramRun(@BindProcess("my-application-id") Process process) {
        assertThat(process.isAlive())
            .isTrue();
    }
}
```

Объект типа **Process** запущенного приложения можно получить через параметр теста, аннотированный **@BindProcess**.

#### Arcadia specific
Для доступа к бинарникам, которые собираются в аркадии, необходимо в **ya.make** тестовых проектов задавать их явно через **DEPENDS**, иначе ланчер не сможет получить к ним доступ.
